/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.blobstore.BlobInputSourceFileMove;
import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.codestation.ArtifactSetAssembler;
import com.ibm.uclab.csrepl.codestation.ArtifactSetAssemblerOptions;
import com.ibm.uclab.csrepl.codestation.ArtifactSetAssemblerSourceFactory;
import com.ibm.uclab.csrepl.codestation.ArtifactSetAssemblerSourceFactoryImpl;
import com.ibm.uclab.csrepl.codestation.DataHandle;
import com.ibm.uclab.csrepl.codestation.DataSource;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.codestation.MetadataHandle;
import com.ibm.uclab.csrepl.codestation.MetadataSource;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.AggregateItemMeta;
import com.urbancode.codestation2.common.aggregate.ItemTableRW;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;

class ArtifactSetAssemblerImpl
implements ArtifactSetAssembler {
    private static final String HASH_ALGORITHM = "SHA-256";
    private final ArtifactSetManager asm;
    private final BlobManager bm;
    private final File tempDir;
    private final File tempMetaFile;
    private final File tempDataFile;
    private boolean metadataOnly;
    private ArtifactSetAssemblerOptions.ArtifactSetIdSource artifactSetIdSource;
    private List<MetadataHandleImpl> metaHandles;
    private ItemTableRW table;
    private OutputStream dataOut;
    private MessageDigest digester;
    private UUID[] newBlobIds;
    private long dataOutPosition;
    private byte[] buffer;
    private String zeroBytesHash;
    private ArtifactSetAssemblerSourceFactory sourceFactory;

    ArtifactSetAssemblerImpl(ArtifactSetManager asm, BlobManager bm, File tempDir, ArtifactSetAssemblerOptions options) {
        this.asm = asm;
        this.bm = bm;
        this.tempDir = tempDir.getAbsoluteFile();
        this.tempMetaFile = new File(tempDir, UUID.randomUUID().toString());
        this.tempDataFile = new File(tempDir, UUID.randomUUID().toString());
        if (options != null) {
            this.metadataOnly = options.isMetadataOnly();
            this.artifactSetIdSource = options.getArtifactSetIdSource();
        }
        if (this.artifactSetIdSource == null) {
            throw new IllegalArgumentException("artifactSetIdSource is required");
        }
        this.metaHandles = new ArrayList<MetadataHandleImpl>();
        this.table = new ItemTableRW();
        this.table.setMetaOnly(this.metadataOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataHandle addData(DataSource source) throws IOException {
        this.validateIsOpen();
        Check.nonNull((Object)source);
        InputStream in = source.getStream();
        try {
            long offset = this.dataOutPosition;
            long length = this.writeAndDigest(in);
            byte[] hash = this.getDigester().digest();
            DataHandleImpl dataHandleImpl = new DataHandleImpl(this, offset, length, hash);
            return dataHandleImpl;
        }
        finally {
            in.close();
        }
    }

    @Override
    public MetadataHandle addMetadata(MetadataSource source) throws IOException {
        this.validateIsOpen();
        Check.nonNull((Object)source);
        FileMetadata meta = source.getMeta();
        AggregateItemMeta m = meta.toAggregateItemMeta(this.metadataOnly);
        MetadataHandleImpl handle = new MetadataHandleImpl(this, m, meta.getLength());
        this.metaHandles.add(handle);
        return handle;
    }

    @Override
    public void associate(MetadataHandle meta, DataHandle data) throws IOException {
        DataHandleImpl dataImpl;
        this.validateIsOpen();
        this.validateMetaAndData(meta, data);
        MetadataHandleImpl metaImpl = (MetadataHandleImpl)meta;
        metaImpl.association = dataImpl = (DataHandleImpl)data;
        metaImpl.meta.setHash(this.createHash(dataImpl.hash));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IOException {
        if (this.table != null) {
            this.sourceFactory = null;
            ItemTableRW localTable = this.table;
            this.table = null;
            List<MetadataHandleImpl> localMetaHandles = this.metaHandles;
            this.metaHandles = null;
            OutputStream localDataOut = this.dataOut;
            this.dataOut = null;
            if (localDataOut != null) {
                localDataOut.close();
            }
            UUID artifactSetId = this.artifactSetIdSource.getArtifactSetId();
            boolean tableExists = this.initTableFromExistingArtifactSet(localTable, artifactSetId);
            boolean tableChanged = false;
            for (MetadataHandleImpl metaHandle : localMetaHandles) {
                AggregateItem item;
                DataHandleImpl dataHandle = metaHandle.association;
                if (dataHandle != null) {
                    item = new AggregateItem(metaHandle.meta, this.tempDataFile.getName(), dataHandle.offset, dataHandle.length);
                } else {
                    String fileName = ".urbancode-zero";
                    item = new AggregateItem(metaHandle.meta, fileName, 0L, metaHandle.length);
                    if (!this.metadataOnly && metaHandle.meta.getType() == 2) {
                        item.setHash(this.getZeroBytesHash());
                    }
                }
                localTable.add(item);
                tableChanged = true;
            }
            boolean ok = false;
            try {
                if (tableChanged || !tableExists) {
                    UUID tableBlobId = this.uploadBlobs(localTable);
                    this.asm.setBlobId(artifactSetId, tableBlobId);
                }
                ok = true;
            }
            finally {
                try {
                    if (!ok) {
                        this.removeNewBlobs();
                    }
                }
                finally {
                    this.newBlobIds = null;
                    IO.delete((File)this.tempDir);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() throws IOException {
        if (this.table != null) {
            this.table = null;
            this.metaHandles = null;
            this.sourceFactory = null;
            OutputStream localDataOut = this.dataOut;
            this.dataOut = null;
            try {
                if (localDataOut != null) {
                    localDataOut.close();
                }
            }
            finally {
                IO.delete((File)this.tempDir);
            }
        }
    }

    @Override
    public boolean isMetadataOnly() {
        this.validateIsOpen();
        return this.metadataOnly;
    }

    @Override
    public ArtifactSetAssemblerSourceFactory getSourceFactory() {
        this.validateIsOpen();
        if (this.sourceFactory == null) {
            this.sourceFactory = new ArtifactSetAssemblerSourceFactoryImpl();
        }
        return this.sourceFactory;
    }

    private void validateMetaAndData(MetadataHandle meta, DataHandle data) {
        Check.nonNull((Object)meta);
        Check.nonNull((Object)data);
        if (!(meta instanceof MetadataHandleImpl)) {
            throw new IllegalArgumentException();
        }
        if (!(data instanceof DataHandleImpl)) {
            throw new IllegalArgumentException();
        }
        MetadataHandleImpl metaImpl = (MetadataHandleImpl)meta;
        DataHandleImpl dataImpl = (DataHandleImpl)data;
        if (metaImpl.assembler != this) {
            throw new IllegalArgumentException();
        }
        if (dataImpl.assembler != this) {
            throw new IllegalArgumentException();
        }
        if (metaImpl.association != null) {
            throw new IllegalArgumentException();
        }
    }

    private OutputStream getDataOut() throws IOException {
        if (this.dataOut == null) {
            IO.mkdirs((File)this.tempDataFile.getParentFile());
            this.dataOut = new BufferedOutputStream(new FileOutputStream(this.tempDataFile));
        }
        return this.dataOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initTableFromExistingArtifactSet(ItemTableRW table, UUID id) throws IOException {
        UUID tableId = this.asm.getBlobId(id);
        if (tableId == null) {
            return false;
        }
        InputStream in = this.bm.openBlob(tableId);
        if (in == null) {
            return false;
        }
        try {
            table.read(in);
        }
        finally {
            in.close();
        }
        return true;
    }

    private long writeAndDigest(InputStream in) throws IOException {
        int read;
        long length = 0L;
        byte[] buffer = this.getBuffer();
        while ((read = in.read(buffer)) != -1) {
            this.getDigester().update(buffer, 0, read);
            if (!this.metadataOnly) {
                this.getDataOut().write(buffer, 0, read);
                this.dataOutPosition += (long)read;
            }
            length += (long)read;
        }
        return length;
    }

    private void removeNewBlobs() throws IOException {
        if (this.newBlobIds == null) {
            return;
        }
        for (UUID id : this.newBlobIds) {
            if (id == null) continue;
            this.bm.removeBlobLocal(id);
        }
    }

    private UUID uploadBlobs(ItemTableRW table) throws IOException {
        if (this.newBlobIds == null) {
            this.newBlobIds = new UUID[2];
        }
        int i = 0;
        if (!this.metadataOnly && this.tempDataFile.isFile()) {
            UUID dataBlobId = this.bm.addBlob(new BlobInputSourceFileMove(this.tempDataFile));
            this.newBlobIds[i++] = dataBlobId;
            table.renameDataFiles(Collections.singletonMap(this.tempDataFile.getName(), dataBlobId.toString()));
        }
        IO.mkdirs((File)this.tempMetaFile.getParentFile());
        table.write(this.tempMetaFile);
        UUID tableBlobId = this.bm.addBlob(new BlobInputSourceFileMove(this.tempMetaFile));
        this.newBlobIds[i++] = tableBlobId;
        return tableBlobId;
    }

    private String createHash(byte[] bytes) throws IOException {
        String hash = null;
        String alg = this.getDigester().getAlgorithm();
        StringBuilder sb = new StringBuilder();
        sb.append(alg);
        sb.append('{');
        sb.append(Hex.encodeHex((byte[])bytes, (boolean)false));
        sb.append('}');
        hash = sb.toString();
        return hash;
    }

    private String getZeroBytesHash() throws IOException {
        if (this.zeroBytesHash == null) {
            this.zeroBytesHash = this.createHash(this.getDigester().digest(new byte[0]));
        }
        return this.zeroBytesHash;
    }

    private MessageDigest getDigester() throws IOException {
        if (this.digester == null) {
            try {
                this.digester = MessageDigest.getInstance(HASH_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return this.digester;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[65536];
        }
        return this.buffer;
    }

    private void validateIsOpen() {
        if (this.table == null) {
            throw new IllegalStateException("closed");
        }
    }

    static class MetadataHandleImpl
    extends MetadataHandle {
        ArtifactSetAssemblerImpl assembler;
        AggregateItemMeta meta;
        long length;
        DataHandleImpl association;

        MetadataHandleImpl(ArtifactSetAssemblerImpl assembler, AggregateItemMeta meta, long length) {
            this.assembler = assembler;
            this.meta = meta;
            this.length = length;
        }
    }

    static class DataHandleImpl
    extends DataHandle {
        ArtifactSetAssemblerImpl assembler;
        long offset;
        long length;
        byte[] hash;

        DataHandleImpl(ArtifactSetAssemblerImpl assembler, long offset, long length, byte[] hash) {
            this.assembler = assembler;
            this.offset = offset;
            this.length = length;
            this.hash = hash;
        }
    }
}

