/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.AggregateItemMeta;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class FileMetadata {
    public static final String JSON_TYPE_KEY = "type";
    public static final String JSON_PATH_KEY = "path";
    public static final String JSON_LENGTH_KEY = "length";
    public static final String JSON_HASH_KEY = "hash";
    public static final String JSON_LAST_MODIFIED_KEY = "lastModified";
    public static final String JSON_UNIX_USER_KEY = "unixUser";
    public static final String JSON_UNIX_GROUP_KEY = "unixGroup";
    public static final String JSON_UNIX_MODE_KEY = "unixMode";
    public static final String JSON_CHARSET_KEY = "charset";
    public static final String JSON_ZOS_DEPLOY_TYPE_KEY = "zosDeployType";
    public static final String JSON_ZOS_DEPLOY_ACTION_KEY = "zosDeployAction";
    public static final String JSON_ZOS_CONTAINER_TYPE_KEY = "zosContainerType";
    public static final String JSON_USER_ATTRIBUTES_KEY = "userAttributes";
    public static final String JSON_META_ONLY_KEY = "metaOnly";
    private static final Set<String> allKeys;
    private static final int SHA_256_DIGIT_COUNT = 64;
    private final Type type;
    private final String path;
    private final long length;
    private String hash;
    private long lastModified;
    private String unixUser;
    private String unixGroup;
    private Integer unixMode;
    private String charset;
    private String zosDeployType;
    private String zosDeployAction;
    private String zosContainerType;
    private JSONObject userAttributes;
    private boolean metaOnly;

    public static String sanitizePath(String path) {
        return Aggregate.sanitizePath((String)path);
    }

    public static boolean isPathValid(String path) {
        return Aggregate.isPathValid((String)path);
    }

    public static boolean isValidHash(String hash) {
        if (hash == null) {
            return false;
        }
        if (hash.length() != 64) {
            return false;
        }
        return FileMetadata.isHash(hash);
    }

    public static FileMetadata fromJSON(JSONObject obj) throws JSONException {
        Type type;
        String t = obj.getString(JSON_TYPE_KEY);
        try {
            type = Type.valueOf(t);
        }
        catch (IllegalArgumentException e) {
            throw new JSONException("Parse error: invalid type: " + t);
        }
        String path = obj.getString(JSON_PATH_KEY);
        long length = obj.getLong(JSON_LENGTH_KEY);
        String hash = obj.optString(JSON_HASH_KEY, null);
        long lastModified = obj.optLong(JSON_LAST_MODIFIED_KEY, 0L);
        String unixUser = obj.optString(JSON_UNIX_USER_KEY, null);
        String unixGroup = obj.optString(JSON_UNIX_GROUP_KEY, null);
        Integer unixMode = null;
        String um = obj.optString(JSON_UNIX_MODE_KEY, null);
        if (um != null) {
            try {
                unixMode = Integer.parseInt(um, 8);
            }
            catch (NumberFormatException e) {
                throw (JSONException)new JSONException("Parse error: invalid mode: " + e.getMessage()).initCause((Throwable)e);
            }
        }
        String charset = obj.optString(JSON_CHARSET_KEY, null);
        String zosDeployType = obj.optString(JSON_ZOS_DEPLOY_TYPE_KEY, null);
        String zosDeployAction = obj.optString(JSON_ZOS_DEPLOY_ACTION_KEY, null);
        String zosContainerType = obj.optString(JSON_ZOS_CONTAINER_TYPE_KEY, null);
        Object ua = obj.opt(JSON_USER_ATTRIBUTES_KEY);
        if (ua != null && !(ua instanceof JSONObject)) {
            throw new JSONException("Parse error: invalid userAttributes: " + ua);
        }
        JSONObject userAttributes = (JSONObject)ua;
        boolean metaOnly = obj.optBoolean(JSON_META_ONLY_KEY, false);
        try {
            FileMetadata m = new FileMetadata(type, path, length);
            m.setHash(hash);
            m.setLastModified(lastModified);
            m.setUnixUser(unixUser);
            m.setUnixGroup(unixGroup);
            m.setUnixMode(unixMode);
            m.setCharset(charset);
            m.setZosDeployType(zosDeployType);
            m.setZosDeployAction(zosDeployAction);
            m.setZosContainerType(zosContainerType);
            m.setUserAttributes(userAttributes);
            m.setMetaOnly(metaOnly);
            return m;
        }
        catch (IllegalArgumentException e) {
            throw (JSONException)new JSONException("Parse error: " + e.getMessage()).initCause((Throwable)e);
        }
    }

    public static Set<String> getAllJSONKeys() {
        return allKeys;
    }

    private static boolean isHash(String hash) {
        for (int i = 0; i < hash.length(); ++i) {
            if (FileMetadata.isHex(hash.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public FileMetadata(Type type, String path, long length) {
        if (type == null) {
            throw new NullPointerException(JSON_TYPE_KEY);
        }
        if (path == null) {
            throw new NullPointerException(JSON_PATH_KEY);
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        if (!FileMetadata.isPathValid(path = FileMetadata.sanitizePath(path))) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        this.type = type;
        this.path = path;
        this.length = length;
    }

    FileMetadata(AggregateItem item) {
        this.type = Type.fromAggregateItemType(item.getType());
        this.path = item.getPath();
        this.length = item.getLength();
        this.hash = this.convertHashFromAggregateItem(item.getHash());
        this.lastModified = item.getLastModified();
        this.unixUser = item.getUnixUser();
        this.unixGroup = item.getUnixGroup();
        this.unixMode = item.getUnixMode();
        this.charset = item.getCharset();
        this.zosDeployType = item.getZosDeployType();
        this.zosDeployAction = item.getZosDeployAction();
        this.zosContainerType = item.getZosContainerType();
        this.userAttributes = item.getUserAttributes();
        this.metaOnly = item.isMetaOnly();
    }

    public Type getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public long getLength() {
        return this.length;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        if (hash != null && !FileMetadata.isValidHash(hash)) {
            throw new IllegalArgumentException("Invalid SHA-256 hash: " + hash);
        }
        this.hash = hash;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getUnixUser() {
        return this.unixUser;
    }

    public void setUnixUser(String unixUser) {
        this.unixUser = unixUser;
    }

    public String getUnixGroup() {
        return this.unixGroup;
    }

    public void setUnixGroup(String unixGroup) {
        this.unixGroup = unixGroup;
    }

    public Integer getUnixMode() {
        return this.unixMode;
    }

    public void setUnixMode(Integer unixMode) {
        this.unixMode = unixMode;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getZosDeployType() {
        return this.zosDeployType;
    }

    public void setZosDeployType(String zosDeployType) {
        this.zosDeployType = zosDeployType;
    }

    public JSONObject getUserAttributes() {
        return this.userAttributes;
    }

    public String getZosDeployAction() {
        return this.zosDeployAction;
    }

    public void setZosDeployAction(String zosDeployAction) {
        this.zosDeployAction = zosDeployAction;
    }

    public String getZosContainerType() {
        return this.zosContainerType;
    }

    public void setZosContainerType(String zosContainerType) {
        this.zosContainerType = zosContainerType;
    }

    public void setUserAttributes(JSONObject userAttributes) {
        this.userAttributes = userAttributes;
    }

    public boolean isMetaOnly() {
        return this.metaOnly;
    }

    public void setMetaOnly(boolean metaOnly) {
        this.metaOnly = metaOnly;
    }

    public JSONObject toJSON() {
        return this.toJSON(FileMetadata.getAllJSONKeys());
    }

    public JSONObject toJSON(Set<String> keys) {
        try {
            JSONObject jo = new JSONObject();
            if (keys.contains(JSON_TYPE_KEY)) {
                jo.put(JSON_TYPE_KEY, (Object)this.type.toString());
            }
            if (keys.contains(JSON_PATH_KEY)) {
                jo.put(JSON_PATH_KEY, (Object)this.path);
            }
            if (keys.contains(JSON_LENGTH_KEY)) {
                jo.put(JSON_LENGTH_KEY, this.length);
            }
            if (keys.contains(JSON_META_ONLY_KEY)) {
                jo.put(JSON_META_ONLY_KEY, this.metaOnly);
            }
            if (this.hash != null && keys.contains(JSON_HASH_KEY)) {
                jo.put(JSON_HASH_KEY, (Object)this.hash);
            }
            if (this.lastModified != 0L && keys.contains(JSON_LAST_MODIFIED_KEY)) {
                jo.put(JSON_LAST_MODIFIED_KEY, this.lastModified);
            }
            if (this.unixUser != null && keys.contains(JSON_UNIX_USER_KEY)) {
                jo.put(JSON_UNIX_USER_KEY, (Object)this.unixUser);
            }
            if (this.unixGroup != null && keys.contains(JSON_UNIX_GROUP_KEY)) {
                jo.put(JSON_UNIX_GROUP_KEY, (Object)this.unixGroup);
            }
            if (this.unixMode != null && keys.contains(JSON_UNIX_MODE_KEY)) {
                jo.put(JSON_UNIX_MODE_KEY, (Object)String.format("%04o", this.unixMode));
            }
            if (this.charset != null && keys.contains(JSON_CHARSET_KEY)) {
                jo.put(JSON_CHARSET_KEY, (Object)this.charset);
            }
            if (this.zosDeployType != null && keys.contains(JSON_ZOS_DEPLOY_TYPE_KEY)) {
                jo.put(JSON_ZOS_DEPLOY_TYPE_KEY, (Object)this.zosDeployType);
            }
            if (this.zosDeployAction != null && keys.contains(JSON_ZOS_DEPLOY_ACTION_KEY)) {
                jo.put(JSON_ZOS_DEPLOY_ACTION_KEY, (Object)this.zosDeployAction);
            }
            if (this.zosContainerType != null && keys.contains(JSON_ZOS_CONTAINER_TYPE_KEY)) {
                jo.put(JSON_ZOS_CONTAINER_TYPE_KEY, (Object)this.zosContainerType);
            }
            if (this.userAttributes != null && keys.contains(JSON_USER_ATTRIBUTES_KEY)) {
                jo.put(JSON_USER_ATTRIBUTES_KEY, (Object)this.userAttributes);
            }
            return jo;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public FileMetadata copy() {
        return this.copy0(this.type, this.path, this.length);
    }

    public FileMetadata withLength(long length) {
        return this.copy0(this.type, this.path, length);
    }

    AggregateItemMeta toAggregateItemMeta(boolean metadataOnly) {
        int t = this.type.toAggregateItemType();
        if (metadataOnly) {
            t |= Integer.MIN_VALUE;
        }
        AggregateItemMeta meta = new AggregateItemMeta(t, this.path);
        meta.setHash(this.convertHashFromFileMetadata(this.hash));
        meta.setLastModified(this.lastModified);
        meta.setUnixUser(this.unixUser);
        meta.setUnixGroup(this.unixGroup);
        meta.setUnixMode(this.unixMode);
        meta.setCharset(this.charset);
        meta.setZosDeployType(this.zosDeployType);
        meta.setZosDeployAction(this.zosDeployAction);
        meta.setZosContainerType(this.zosContainerType);
        meta.setUserAttributes(this.userAttributes);
        return meta;
    }

    private String convertHashFromAggregateItem(String hash) {
        if (hash == null) {
            return null;
        }
        int leftBrace = hash.indexOf(123);
        int rightBrace = hash.indexOf(125);
        if (leftBrace == -1 || rightBrace == -1 || rightBrace - leftBrace - 1 != 64) {
            throw new RuntimeException("Invalid SHA-256 hash: " + hash);
        }
        String h = hash.substring(leftBrace + 1, rightBrace).toLowerCase(Locale.US);
        if (!FileMetadata.isHash(h)) {
            throw new RuntimeException("Invalid SHA-256 hash: " + hash);
        }
        return h;
    }

    private String convertHashFromFileMetadata(String hash) {
        if (hash == null) {
            return null;
        }
        return "SHA-256{" + hash + "}";
    }

    private FileMetadata copy0(Type type, String path, long length) {
        FileMetadata c = new FileMetadata(type, path, length);
        c.hash = this.hash;
        c.lastModified = this.lastModified;
        c.unixUser = this.unixUser;
        c.unixGroup = this.unixGroup;
        c.unixMode = this.unixMode;
        c.charset = this.charset;
        c.zosDeployType = this.zosDeployType;
        c.zosDeployAction = this.zosDeployAction;
        c.zosContainerType = this.zosContainerType;
        c.userAttributes = this.userAttributes;
        if (c.userAttributes != null) {
            try {
                c.userAttributes = new JSONObject(c.userAttributes.toString());
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return c;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(JSON_TYPE_KEY);
        set.add(JSON_PATH_KEY);
        set.add(JSON_LENGTH_KEY);
        set.add(JSON_HASH_KEY);
        set.add(JSON_LAST_MODIFIED_KEY);
        set.add(JSON_UNIX_USER_KEY);
        set.add(JSON_UNIX_GROUP_KEY);
        set.add(JSON_UNIX_MODE_KEY);
        set.add(JSON_CHARSET_KEY);
        set.add(JSON_ZOS_DEPLOY_TYPE_KEY);
        set.add(JSON_ZOS_DEPLOY_ACTION_KEY);
        set.add(JSON_ZOS_CONTAINER_TYPE_KEY);
        set.add(JSON_USER_ATTRIBUTES_KEY);
        set.add(JSON_META_ONLY_KEY);
        allKeys = Collections.unmodifiableSet(set);
    }

    public static enum Type {
        DIRECTORY{

            @Override
            int toAggregateItemType() {
                return 2;
            }
        }
        ,
        FILE{

            @Override
            int toAggregateItemType() {
                return 1;
            }
        }
        ,
        SYMLINK{

            @Override
            int toAggregateItemType() {
                return 3;
            }
        };


        abstract int toAggregateItemType();

        static Type fromAggregateItemType(int t) {
            switch (t) {
                case 2: {
                    return DIRECTORY;
                }
                case 1: {
                    return FILE;
                }
                case 3: {
                    return SYMLINK;
                }
            }
            throw new RuntimeException("Missing case: " + t);
        }
    }
}

