/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.http.range.ByteRange;
import com.ibm.uclab.csrepl.http.range.ByteRangeParser;
import com.ibm.uclab.csrepl.http.range.RangeFormatException;
import com.ibm.uclab.csrepl.rest.Errors;
import java.util.Collections;
import java.util.List;

public class ByteRangeHeaderParam {
    private final String text;
    private final ByteRangeParser parser;

    public ByteRangeHeaderParam() {
        this.text = null;
        this.parser = null;
    }

    public ByteRangeHeaderParam(String text) {
        this.text = text;
        this.parser = text != null ? new ByteRangeParser(text) : null;
    }

    public String toString() {
        return this.getText();
    }

    public String getText() {
        return this.text;
    }

    public List<ByteRange> getRanges() {
        if (this.parser == null) {
            return Collections.emptyList();
        }
        try {
            return this.parser.getRanges();
        }
        catch (RangeFormatException e) {
            throw Errors.badRequest("Invalid Range request: " + e.getMessage(), e);
        }
    }
}

