/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.exceptions.AuthenticationException;
import com.ibm.uclab.csrepl.exceptions.AuthorizationException;
import com.ibm.uclab.csrepl.exceptions.CodestationSecurityException;
import com.ibm.uclab.csrepl.exceptions.CorruptStreamException;
import com.ibm.uclab.csrepl.exceptions.ServerFailedException;
import com.ibm.uclab.csrepl.exceptions.ServerUnavailableException;
import com.ibm.uclab.csrepl.exceptions.UpstreamServerFailedException;
import com.ibm.uclab.csrepl.exceptions.UpstreamServerUnavailableException;
import com.ibm.uclab.csrepl.http.range.ByteContentRange;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.log4j.Logger;

final class Errors {
    private static final Logger log = Logger.getLogger(Errors.class);

    static WebApplicationException notFound(String message) {
        return Errors.notFound(message, null);
    }

    static WebApplicationException notFound(String message, Throwable cause) {
        return Errors.createException(Response.Status.NOT_FOUND, message, cause);
    }

    static WebApplicationException badRequest(String message) {
        return Errors.badRequest(message, null);
    }

    static WebApplicationException badRequest(String message, Throwable cause) {
        return Errors.createException(Response.Status.BAD_REQUEST, message, cause);
    }

    static WebApplicationException serviceUnavailable(String message) {
        return Errors.serviceUnavailable(message, null);
    }

    static WebApplicationException serviceUnavailable(String message, Throwable cause) {
        return Errors.createException(Response.Status.SERVICE_UNAVAILABLE, message, cause);
    }

    static WebApplicationException unauthorized(String message) {
        return Errors.unauthorized(message, null);
    }

    static WebApplicationException unauthorized(String message, Throwable cause) {
        return Errors.createException(Response.Status.UNAUTHORIZED, message, cause);
    }

    static WebApplicationException forbidden(String message) {
        return Errors.forbidden(message, null);
    }

    static WebApplicationException forbidden(String message, Throwable cause) {
        return Errors.createException(Response.Status.FORBIDDEN, message, cause);
    }

    static WebApplicationException internalServerError(String message) {
        return Errors.internalServerError(message, null);
    }

    static WebApplicationException internalServerError(String message, Throwable cause) {
        return Errors.createException(Response.Status.INTERNAL_SERVER_ERROR, message, cause);
    }

    static WebApplicationException notImplemented(String message) {
        return Errors.notImplemented(message, null);
    }

    static WebApplicationException notImplemented(String message, Throwable cause) {
        return Errors.createException(501, message, cause);
    }

    static WebApplicationException badGateway(String message) {
        return Errors.badGateway(message, null);
    }

    static WebApplicationException badGateway(String message, Throwable cause) {
        return Errors.createException(502, message, cause);
    }

    static WebApplicationException gatewayTimeout(String message) {
        return Errors.gatewayTimeout(message, null);
    }

    static WebApplicationException gatewayTimeout(String message, Throwable cause) {
        return Errors.createException(504, message, cause);
    }

    static WebApplicationException requestedRangeNotSatisfiable(String message, long entityLength) {
        Response.ResponseBuilder builder = Errors.initExceptionResponseBuilder(416, message);
        builder.header("Content-Range", (Object)ByteContentRange.forUnsatisfiedRange(entityLength));
        return Errors.createException(builder.build(), null);
    }

    static <T extends Throwable> T mapException(T e) {
        if (e instanceof WebApplicationException) {
            return e;
        }
        if (e instanceof ConnectionPoolTimeoutException) {
            throw Errors.serviceUnavailable("Connection pool exhausted: " + e.getMessage(), e);
        }
        if (e instanceof ConnectTimeoutException) {
            throw Errors.gatewayTimeout("Connection to upstream server timed out: " + e.getMessage(), e);
        }
        if (e instanceof AuthenticationException) {
            throw Errors.unauthorized("Cannot authenticate with peer: " + e.getMessage(), e);
        }
        if (e instanceof AuthorizationException) {
            throw Errors.forbidden("Not authorized: " + e.getMessage(), e);
        }
        if (e instanceof ServerUnavailableException) {
            throw Errors.gatewayTimeout("Upstream server unavailable: " + e.getMessage(), e);
        }
        if (e instanceof UpstreamServerFailedException) {
            throw Errors.badGateway("Upstream server failed: " + e.getMessage(), e);
        }
        if (e instanceof UpstreamServerUnavailableException) {
            throw Errors.gatewayTimeout("Upstream server unavailable: " + e.getMessage(), e);
        }
        if (e instanceof ServerFailedException) {
            throw Errors.badGateway("Upstream server failed: " + e.getMessage(), e);
        }
        if (e instanceof CorruptStreamException) {
            throw Errors.badRequest("Transfer aborted: " + e.getMessage(), e);
        }
        if (e instanceof UnsupportedOperationException) {
            throw Errors.forbidden("Unsupported operation: " + e.getMessage(), e);
        }
        if (e instanceof CodestationSecurityException) {
            throw Errors.forbidden(e.getMessage(), e);
        }
        return e;
    }

    private static WebApplicationException createException(Response.Status status, String message, Throwable cause) {
        return Errors.createException(Errors.createExceptionResponse(status, message).build(), cause);
    }

    private static WebApplicationException createException(int status, String message, Throwable cause) {
        return Errors.createException(Errors.initExceptionResponseBuilder(status, message).build(), cause);
    }

    private static WebApplicationException createException(Response response, Throwable cause) {
        WebApplicationException e = new WebApplicationException(cause, response);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Created WebApplicationException", (Throwable)e);
        }
        return e;
    }

    private static Response.ResponseBuilder createExceptionResponse(Response.Status status, String message) {
        if (message != null) {
            message = message.trim() + "\r\n";
        }
        return Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).header("X-Content-Type-Options", (Object)"nosniff").entity((Object)message);
    }

    private static Response.ResponseBuilder initExceptionResponseBuilder(int status, String message) {
        if (message != null) {
            message = message.trim() + "\r\n";
        }
        return Response.status((int)status).type(MediaType.TEXT_PLAIN_TYPE).header("X-Content-Type-Options", (Object)"nosniff").entity((Object)message);
    }

    private Errors() {
        throw new UnsupportedOperationException();
    }
}

