/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.rest.Errors;
import com.ibm.uclab.csrepl.rest.MetaFilter;
import com.urbancode.commons.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.ws.rs.core.MediaType;
import org.codehaus.jettison.json.JSONException;

class MetaFilterParser {
    private InputStream in;
    private MediaType type;
    private MetaFilter filter;

    MetaFilterParser(InputStream in, MediaType type) {
        this.in = in;
        this.type = type;
    }

    MetaFilter getFilter() throws IOException {
        Charset cs;
        if (this.filter != null) {
            return this.filter;
        }
        if (this.in == null) {
            this.filter = MetaFilter.getDefaultFilter();
            return this.filter;
        }
        if (this.type == null) {
            this.type = MediaType.APPLICATION_JSON_TYPE;
        }
        if (!this.type.getType().equals(MediaType.APPLICATION_JSON_TYPE.getType())) {
            throw Errors.badRequest("Invalid media type: " + this.type);
        }
        if (!this.type.getSubtype().equals(MediaType.APPLICATION_JSON_TYPE.getSubtype())) {
            throw Errors.badRequest("Invalid media type: " + this.type);
        }
        String charset = (String)this.type.getParameters().get("charset");
        if (charset == null) {
            charset = "UTF-8";
        }
        try {
            cs = Charset.forName(charset);
        }
        catch (Exception e) {
            throw Errors.badRequest("Invalid charset: " + charset);
        }
        String json = IO.readText((InputStream)this.in, (Charset)cs);
        if (json.length() == 0) {
            this.filter = MetaFilter.getDefaultFilter();
            return this.filter;
        }
        try {
            this.filter = MetaFilter.fromJSON(json);
            return this.filter;
        }
        catch (JSONException e) {
            throw Errors.badRequest("Invalid filter JSON: " + e.getMessage(), e);
        }
    }
}

