/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.codestation.ArtifactSetBuilder;
import com.ibm.uclab.csrepl.codestation.ArtifactSetReader;
import com.ibm.uclab.csrepl.codestation.ArtifactSetReaders;
import com.ibm.uclab.csrepl.codestation.CodestationInputStream;
import com.ibm.uclab.csrepl.codestation.CodestationService;
import com.ibm.uclab.csrepl.codestation.CodestationServiceLookup;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.codestation.security.ArtifactsResourceSecurity;
import com.ibm.uclab.csrepl.codestation.security.ArtifactsResourceSecurityLookup;
import com.ibm.uclab.csrepl.exceptions.CodestationSecurityException;
import com.ibm.uclab.csrepl.rest.DigestParam;
import com.ibm.uclab.csrepl.rest.Errors;
import com.ibm.uclab.csrepl.rest.KeysParam;
import com.ibm.uclab.csrepl.rest.MediaTypeParam;
import com.ibm.uclab.csrepl.rest.MetaFilter;
import com.ibm.uclab.csrepl.rest.MetaFilterParser;
import com.ibm.uclab.csrepl.rest.MetaParser;
import com.ibm.uclab.csrepl.rest.UUIDParam;
import com.ibm.uclab.csrepl.streams.ArtifactSetReaderInputStream;
import com.ibm.uclab.csrepl.streams.HashCheckingInputStream;
import com.ibm.uclab.csrepl.streams.HashInjectingInputStream;
import com.urbancode.commons.util.IO;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;

@Path(value="artifacts")
public class ArtifactsResource {
    private static final Logger log = Logger.getLogger(ArtifactsResource.class);
    private static final AtomicLong counter = new AtomicLong();
    private static final String MULTIPART_MIXED = "multipart/mixed";
    private static final MediaType jsonType = new MediaType(MediaType.APPLICATION_JSON_TYPE.getType(), MediaType.APPLICATION_JSON_TYPE.getSubtype(), Collections.singletonMap("charset", IO.utf8().name()));
    private final CodestationService cs;
    private final ArtifactsResourceSecurity security;

    public ArtifactsResource() {
        this(CodestationServiceLookup.get(), ArtifactsResourceSecurityLookup.get());
    }

    public ArtifactsResource(@Context CodestationService cs, @Context ArtifactsResourceSecurity security) {
        this.cs = cs;
        this.security = security;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="status")
    @Produces(value={"text/plain"})
    public String getStatus() {
        String string;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../artifacts/status", op));
        }
        try {
            this.getCS();
            string = "OK";
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{artifactSetId}/meta")
    public Response getMeta(@PathParam(value="artifactSetId") UUIDParam artifactSetId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @QueryParam(value="keys") KeysParam keys) throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../artifacts/%s/meta", op, artifactSetId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
            log.trace((Object)String.format("[op=%d] Param: %s=%s", op, "keys", keys));
        }
        try {
            this.assertCanReadArtifacts(artifactSetId.getUUID());
            response = this.doGetMeta(artifactSetId.getUUID(), DigestParam.toDigest(digest), MetaFilter.fromKeysParam(keys));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{artifactSetId}/meta")
    @Consumes(value={"application/json"})
    public Response getMeta(@PathParam(value="artifactSetId") UUIDParam artifactSetId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @HeaderParam(value="Content-Type") MediaTypeParam type, InputStream filterJson) throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] POST .../artifacts/%s/meta", op, artifactSetId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "Content-Type", type));
        }
        try {
            UUID asid = artifactSetId.getUUID();
            this.assertCanReadArtifacts(asid);
            MessageDigest dig = DigestParam.toDigest(digest);
            MetaFilter filter = MetaFilter.getDefaultFilter();
            if (filterJson != null) {
                if (dig != null) {
                    filterJson = new HashCheckingInputStream(filterJson, dig);
                }
                filter = new MetaFilterParser(filterJson, MediaTypeParam.toType(type)).getFilter();
            }
            response = this.doGetMeta(asid, dig, filter);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{artifactSetId}")
    public Response getData(@PathParam(value="artifactSetId") UUIDParam artifactSetId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest) throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../artifacts/%s", op, artifactSetId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
        }
        try {
            this.assertCanReadArtifacts(artifactSetId.getUUID());
            response = this.doGetData(artifactSetId, digest, new MediaTypeParam(), null);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{artifactSetId}")
    @Consumes(value={"application/json"})
    public Response getData(@PathParam(value="artifactSetId") UUIDParam artifactSetId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @HeaderParam(value="Content-Type") MediaTypeParam type, InputStream filterJson) throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] POST .../artifacts/%s", op, artifactSetId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "Content-Type", type));
        }
        try {
            this.assertCanReadArtifacts(artifactSetId.getUUID());
            response = this.doGetData(artifactSetId, digest, type, filterJson);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @POST
    @Path(value="{artifactSetId}/meta/update")
    @Consumes(value={"application/json"})
    public Response updateMeta(@PathParam(value="artifactSetId") UUIDParam artifactSetId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @HeaderParam(value="Content-Type") MediaTypeParam type, InputStream metaJson) throws Exception {
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] POST .../artifacts/%s/meta/update", op, artifactSetId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "Content-Type", type));
        }
        CodestationService cs = this.getCS();
        UUID asid = artifactSetId.getUUID();
        this.assertCanReadArtifacts(asid);
        this.assertCanUpdateArtifacts(asid);
        MessageDigest dig = null;
        if (digest != null && (dig = digest.getDigest()) != null && metaJson != null) {
            metaJson = new HashCheckingInputStream(metaJson, dig);
        }
        List<FileMetadata> meta = new MetaParser(metaJson, type.getType()).getMeta();
        ArtifactSetBuilder builder = cs.createMetadataOnlyBuilder(asid);
        try {
            for (FileMetadata m : meta) {
                builder.addItem(m, null);
            }
            builder.commit();
        }
        finally {
            builder.abort();
        }
        Response.ResponseBuilder resb = Response.noContent();
        resb.header("X-Codestation-Artifact-Set-ID", (Object)asid.toString());
        Response response = resb.build();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
        {
            catch (Exception e) {
                try {
                    throw Errors.mapException(e);
                }
                catch (Throwable throwable) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("[op=%d] Complete", op));
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @POST
    @Path(value="{artifactSetId}/update")
    @Consumes(value={"multipart/mixed"})
    public Response updateData(@PathParam(value="artifactSetId") UUIDParam artifactSetId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @HeaderParam(value="Content-Type") MediaTypeParam type, InputStream dataMultipart) throws Exception {
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] POST .../artifacts/%s/update", op, artifactSetId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "Content-Type", type));
        }
        CodestationService cs = this.getCS();
        UUID asid = artifactSetId.getUUID();
        this.assertCanReadArtifacts(asid);
        this.assertCanUpdateArtifacts(asid);
        String boundary = null;
        if (type != null) {
            boundary = this.getBoundary(type.getType());
        }
        if (boundary == null) {
            throw Errors.badRequest("No boundary in Content-Type");
        }
        MessageDigest dig = null;
        if (digest != null && (dig = digest.getDigest()) != null && dataMultipart != null) {
            dataMultipart = new HashCheckingInputStream(dataMultipart, dig);
        }
        ArtifactSetBuilder builder = cs.createBuilder(asid);
        try {
            ArtifactSetReader reader = ArtifactSetReaders.fromMultipart(dataMultipart, boundary);
            try {
                CodestationInputStream in;
                while ((in = reader.read()) != null) {
                    try {
                        if (in.getMeta().getType() == FileMetadata.Type.DIRECTORY) {
                            builder.addItem(in.getMeta(), null);
                            continue;
                        }
                        builder.addItem(in.getMeta(), in);
                    }
                    finally {
                        in.close();
                    }
                }
            }
            finally {
                reader.close();
            }
            builder.commit();
        }
        finally {
            builder.abort();
        }
        Response.ResponseBuilder resb = Response.noContent();
        resb.header("X-Codestation-Artifact-Set-ID", (Object)asid.toString());
        Response response = resb.build();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
        {
            catch (Exception e) {
                try {
                    throw Errors.mapException(e);
                }
                catch (Throwable throwable) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("[op=%d] Complete", op));
                    }
                    throw throwable;
                }
            }
        }
    }

    private CodestationService getCS() {
        if (this.cs == null) {
            throw Errors.notImplemented("Artifacts service unavailable");
        }
        return this.cs;
    }

    private Response doGetData(UUIDParam artifactSetId, DigestParam digest, MediaTypeParam type, InputStream filterJson) throws Exception {
        CodestationService cs = this.getCS();
        UUID asid = artifactSetId.getUUID();
        MessageDigest dig = null;
        if (digest != null && (dig = digest.getDigest()) != null && filterJson != null) {
            filterJson = new HashCheckingInputStream(filterJson, dig);
        }
        try {
            ArtifactSetReaderInputStream in;
            MetaFilter filter = new MetaFilterParser(filterJson, type.getType()).getFilter();
            ArtifactSetReader reader = cs.openArtifactSet(asid, filter.getFileFilter());
            InputStream resIn = in = new ArtifactSetReaderInputStream(reader);
            if (dig != null) {
                resIn = new HashInjectingInputStream(resIn, dig);
            }
            MediaType resType = this.getMultipartType(in.getBoundary());
            Response.ResponseBuilder resb = Response.ok((Object)resIn, (MediaType)resType);
            resb.header("X-Codestation-Artifact-Set-ID", (Object)asid.toString());
            if (dig != null) {
                resb.header("X-Codestation-Digest-Algorithm", (Object)dig.getAlgorithm());
            }
            return resb.build();
        }
        catch (FileNotFoundException e) {
            throw this.handleFileNotFoundException(asid, e);
        }
        catch (Exception e) {
            throw Errors.mapException(e);
        }
    }

    private MediaType getMultipartType(String boundary) {
        return new MediaType("multipart", "mixed", Collections.singletonMap("boundary", boundary));
    }

    private String getBoundary(MediaType type) {
        if (type == null) {
            return null;
        }
        return (String)type.getParameters().get("boundary");
    }

    private Response doGetMeta(UUID asid, MessageDigest digest, MetaFilter filter) throws Exception {
        CodestationService cs = this.getCS();
        try {
            List<FileMetadata> meta = cs.getMetadata(asid, filter.getFileFilter());
            JSONArray jarray = new JSONArray();
            for (FileMetadata m : meta) {
                jarray.put((Object)m.toJSON(filter.getKeys()));
            }
            InputStream resIn = new ByteArrayInputStream(jarray.toString().getBytes(IO.utf8()));
            if (digest != null) {
                resIn = new HashInjectingInputStream(resIn, digest);
            }
            Response.ResponseBuilder resb = Response.ok((Object)resIn, (MediaType)jsonType);
            resb.header("X-Codestation-Artifact-Set-ID", (Object)asid.toString());
            if (digest != null) {
                resb.header("X-Codestation-Digest-Algorithm", (Object)digest.getAlgorithm());
            }
            return resb.build();
        }
        catch (FileNotFoundException e) {
            throw this.handleFileNotFoundException(asid, e);
        }
        catch (Exception e) {
            throw Errors.mapException(e);
        }
    }

    private WebApplicationException handleFileNotFoundException(UUID asid, FileNotFoundException e) {
        log.warn((Object)("Sending 404 to client: no artifact files for " + asid + ": " + e.getMessage()));
        return Errors.notFound("Artifact set not found: " + asid, e);
    }

    public synchronized ArtifactsResourceSecurity getSecurity() {
        return this.security;
    }

    private void assertCanReadArtifacts(UUID artifactSetId) {
        try {
            ArtifactsResourceSecurity security = this.getSecurity();
            if (security != null) {
                security.assertCanReadArtifacts(artifactSetId);
            }
        }
        catch (CodestationSecurityException e) {
            throw Errors.mapException(e);
        }
    }

    private void assertCanUpdateArtifacts(UUID artifactSetId) {
        try {
            ArtifactsResourceSecurity security = this.getSecurity();
            if (security != null) {
                security.assertCanUpdateArtifacts(artifactSetId);
            }
        }
        catch (CodestationSecurityException e) {
            throw Errors.mapException(e);
        }
    }
}

