/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.client.ops;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.Download;
import com.ibm.uclab.csrepl.client.ops.VerifyResult;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.codestation.Filter;
import com.urbancode.commons.fileutils.filelister.FileLister;
import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.log4j.Logger;

public class DownloadSync
extends Download {
    static final Logger log = Logger.getLogger(DownloadSync.class);
    private UUID prevArtifactSetId;
    private boolean fullClean;
    protected List<String> downloadList;
    protected List<FileMetadata> prevMeta;

    public DownloadSync(CodestationClient client, File destination, UUID artifactSetId, UUID prevArtifactSetId) {
        super(client, destination, artifactSetId);
        this.prevArtifactSetId = prevArtifactSetId;
        this.downloadList = new ArrayList<String>();
    }

    public void setFullClean(boolean fullClean) {
        this.fullClean = fullClean;
    }

    @Override
    public void run() throws IOException {
        this.downloadMetadata();
        this.cleanup();
        this.buildDownloadList();
        this.downloadFiles();
    }

    @Override
    protected Filter getFileDownloadFilter() {
        return Filter.compile(this.downloadList, null);
    }

    @Override
    protected boolean skipFileDownload(Filter filter) {
        return filter.getIncludes().isEmpty();
    }

    @Override
    protected void downloadMetadata() throws IOException {
        super.downloadMetadata();
        if (!this.fullClean && this.prevArtifactSetId != null) {
            log.info((Object)("Downloading metadata for artifact set " + this.prevArtifactSetId + "."));
            try {
                Filter filter = this.getMetadataDownloadFilter();
                this.prevMeta = this.client.getMetadata(this.prevArtifactSetId, filter);
            }
            catch (FileNotFoundException e) {
                log.warn((Object)("Doing full clean: artifact set not found: " + this.prevArtifactSetId));
            }
            log.info((Object)"Download complete.");
        }
    }

    private void cleanup() throws IOException {
        if (this.fullClean) {
            log.info((Object)"Running full cleanup of target directory.");
            this.cleanupFull();
            log.info((Object)"Cleanup complete.");
        } else if (this.prevMeta != null) {
            log.info((Object)"Running delta cleanup of target directory.");
            this.cleanupDelta();
            log.info((Object)"Cleanup complete.");
        } else {
            log.info((Object)"Skipping cleanup of target directory: no previous version found for delta cleanup and full cleanup not enabled");
        }
    }

    private void buildDownloadList() throws IOException {
        log.info((Object)"Scanning for out-of-date files.");
        long startValidation = System.currentTimeMillis();
        for (FileMetadata m : this.meta) {
            File f = this.toFile(m);
            VerifyResult r = this.verify(f, m);
            if (r.isOK()) {
                log.info((Object)("Up-to-date: " + r.getPath()));
                continue;
            }
            log.info((Object)("Out-of-date: " + r.getMessage() + ": " + r.getPath()));
            String detail = r.getDetail();
            if (detail != null) {
                log.info((Object)("             " + detail));
            }
            this.downloadList.add(m.getPath());
        }
        long validationDuration = System.currentTimeMillis() - startValidation;
        log.info((Object)("Scan for " + this.meta.size() + " files complete in " + validationDuration / 1000L + " seconds."));
    }

    private void cleanupFull() throws IOException {
        assert (this.prevMeta == null);
        FileListerBuilder flb = new FileListerBuilder(this.destination);
        flb.symlinks(FileListerBuilder.Symlinks.AS_LINK);
        flb.directories(FileListerBuilder.Directories.INCLUDE_ALL);
        if (this.includes != null) {
            flb.includes().addAll(this.includes);
        }
        if (this.excludes != null) {
            flb.excludes().addAll(this.excludes);
        }
        FileLister lister = flb.build();
        Map<String, FileMetadata> newPaths = this.mapByPath(this.meta);
        for (TypedFile tf : lister.list()) {
            File f = tf.translate(this.destination);
            if (!newPaths.keySet().contains(tf.path())) {
                log.info((Object)("Unneeded path: " + tf.path()));
                this.delete(f);
                continue;
            }
            FileMetadata m = newPaths.get(tf.path());
            if (this.isSameType(tf, m)) continue;
            log.info((Object)("Incorrect path type: " + tf.path()));
            this.delete(f);
        }
    }

    private void cleanupDelta() throws IOException {
        assert (this.prevMeta != null);
        Map<String, FileMetadata> deletedPaths = this.mapByPath(this.prevMeta);
        Map<String, FileMetadata> newPaths = this.mapByPath(this.meta);
        deletedPaths.keySet().removeAll(newPaths.keySet());
        for (String string : deletedPaths.keySet()) {
            log.info((Object)("Unneeded path: " + string));
        }
        for (Map.Entry entry : newPaths.entrySet()) {
            FileMetadata m = (FileMetadata)entry.getValue();
            File f = new File(this.destination, m.getPath());
            if (!f.exists()) {
                log.info((Object)("Path missing: " + (String)entry.getKey()));
                continue;
            }
            if (this.isSameType(f, m)) continue;
            log.info((Object)("Incorrect path type: " + (String)entry.getKey()));
            deletedPaths.put(m.getPath(), m);
        }
        Iterator<String> pathIterator = new TreeSet<String>(deletedPaths.keySet()).descendingIterator();
        while (pathIterator.hasNext()) {
            File file = new File(this.destination, pathIterator.next());
            file.delete();
            if (file.exists()) continue;
            log.info((Object)("Deleted: " + file.getAbsolutePath()));
        }
    }

    private Map<String, FileMetadata> mapByPath(List<FileMetadata> meta) {
        HashMap<String, FileMetadata> map = new HashMap<String, FileMetadata>();
        for (FileMetadata m : meta) {
            map.put(this.stripSourcePathOffset(m.getPath()), m);
        }
        return map;
    }
}

