/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.codestation.CodestationInputStream;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.codestation.StreamFactoryArtifactSet;
import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateInputStream;
import com.urbancode.codestation2.common.aggregate.streams.StreamFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;

class CodestationServiceImplOpenFile {
    private final ArtifactSetManager asm;
    private final BlobManager bm;
    private final UUID id;
    private final String path;

    CodestationServiceImplOpenFile(ArtifactSetManager asm, BlobManager bm, UUID id, String path) {
        path = Aggregate.sanitizePath((String)path);
        if (!Aggregate.isPathValid((String)path)) {
            throw new IllegalArgumentException("invalid path");
        }
        this.asm = asm;
        this.bm = bm;
        this.id = id;
        this.path = path;
    }

    CodestationInputStream run() throws IOException {
        StreamFactoryArtifactSet factory = new StreamFactoryArtifactSet(this.asm, this.bm, this.id);
        Aggregate aggr = new Aggregate(null, null, (StreamFactory)factory);
        AggregateInputStream in = aggr.read(this.path);
        if (in == null) {
            try {
                String p = new String(this.path.getBytes("ISO-8859-1"), "UTF-8");
                in = aggr.read(p);
            }
            catch (Exception swallow) {
                // empty catch block
            }
        }
        if (in == null) {
            throw new FileNotFoundException(String.format("No file for path: artifactSetId=%s, path=%s", this.id, this.path));
        }
        return new CodestationInputStream((InputStream)in, new FileMetadata(in.getItem()));
    }
}

