/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.exceptions.CodestationSecurityException;
import com.ibm.uclab.csrepl.ptrstore.IDMapping;
import com.ibm.uclab.csrepl.ptrstore.IDMappingReader;
import com.ibm.uclab.csrepl.rest.Errors;
import com.urbancode.commons.util.IO;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.log4j.Logger;

class IDMappingEntity
implements StreamingOutput {
    private static final Logger log = Logger.getLogger(IDMappingEntity.class);
    private static final Errors errors = new Errors(log);
    private final ArtifactSetManager asm;

    IDMappingEntity(ArtifactSetManager asm) {
        this.asm = asm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) throws IOException, WebApplicationException {
        try {
            IDMappingReader rd = this.asm.getMappingReader();
            try {
                OutputStreamWriter wr = IO.writer((OutputStream)out, (Charset)IO.utf8());
                try {
                    IDMapping m;
                    while ((m = rd.read()) != null) {
                        wr.append(m.toString());
                        wr.append("\r\n");
                    }
                }
                finally {
                    wr.close();
                }
            }
            finally {
                rd.close();
            }
        }
        catch (CodestationSecurityException e) {
            throw errors.forbidden(e.getMessage(), e);
        }
    }
}

