/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.client.ops;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.ArtifactSetWriter;
import com.ibm.uclab.csrepl.client.ops.DownloadBase;
import com.ibm.uclab.csrepl.codestation.ArtifactSetReader;
import com.ibm.uclab.csrepl.codestation.Filter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;

public class Download
extends DownloadBase {
    private static final Logger log = Logger.getLogger(Download.class);
    protected boolean setExecuteBits;
    protected boolean verifyFiles;
    protected Charset outputCharset;
    private int maxDownloadAttempts = 1;

    public Download(CodestationClient client, File destination, UUID artifactSetId) {
        this(client, destination, Collections.singletonList(artifactSetId));
    }

    protected Download(CodestationClient client, File destination, List<UUID> artifactSetIds) {
        super(client, destination, artifactSetIds);
    }

    public void setSetExecuteBits(boolean setExecuteBits) {
        this.setExecuteBits = setExecuteBits;
    }

    public void setVerifyFiles(boolean verifyFiles) {
        this.verifyFiles = verifyFiles;
    }

    public void setOutputCharset(Charset outputCharset) {
        this.outputCharset = outputCharset;
    }

    public void setMaxDownloadAttempts(int maxDownloadAttempts) {
        if (maxDownloadAttempts <= 0) {
            throw new IllegalArgumentException("setMaxDownloadAttempts must be called with a positive number");
        }
        this.maxDownloadAttempts = maxDownloadAttempts;
    }

    @Override
    public void run() throws IOException {
        this.downloadFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOException tryDownloadOnce(UUID id, Filter filter) {
        try {
            ArtifactSetReader reader = this.client.openArtifactSet(id, filter);
            try {
                ArtifactSetWriter writer = new ArtifactSetWriter(this.destination, reader);
                writer.setSetExecuteBits(this.setExecuteBits);
                writer.setVerifyFiles(this.verifyFiles);
                writer.setOutputCharset(this.outputCharset);
                writer.setStrippedPrefix(this.sourcePathOffset);
                writer.run();
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }

    protected void downloadFiles() throws IOException {
        UUID id = this.getFileDownloadArtifactSetId();
        Filter filter = this.getFileDownloadFilter();
        if (this.skipFileDownload(filter)) {
            log.info((Object)"File download not required.");
            return;
        }
        IOException exception = new IOException();
        for (int i = 0; i < this.maxDownloadAttempts && exception != null; ++i) {
            exception = this.tryDownloadOnce(id, filter);
            if (exception == null) continue;
            log.info((Object)"Artifact set download failed with an IOException");
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected UUID getFileDownloadArtifactSetId() {
        return (UUID)this.artifactSetIds.get(0);
    }

    protected Filter getFileDownloadFilter() {
        return Filter.compile(this.includes, this.excludes).withPrefix(this.sourcePathOffset);
    }

    protected boolean skipFileDownload(Filter filter) {
        return false;
    }
}

