/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.bm.BlobManagerLookup;
import com.ibm.uclab.csrepl.bm.security.BmResourceSecurity;
import com.ibm.uclab.csrepl.bm.security.BmResourceSecurityLookup;
import com.ibm.uclab.csrepl.exceptions.CodestationSecurityException;
import com.ibm.uclab.csrepl.http.range.ByteContentRange;
import com.ibm.uclab.csrepl.http.range.ByteRange;
import com.ibm.uclab.csrepl.rest.ArtifactsResource;
import com.ibm.uclab.csrepl.rest.ByteRangeHeaderParam;
import com.ibm.uclab.csrepl.rest.DigestParam;
import com.ibm.uclab.csrepl.rest.Errors;
import com.ibm.uclab.csrepl.rest.UUIDParam;
import com.ibm.uclab.csrepl.streams.HashCheckingInputStream;
import com.ibm.uclab.csrepl.streams.HashInjectingInputStream;
import com.ibm.uclab.csrepl.streams.SubRangeInputStream;
import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;

@Path(value="bm")
public class BmResource {
    static final int PARTIAL_CONTENT = 206;
    private static final Logger log = Logger.getLogger(ArtifactsResource.class);
    private static final Errors errors = new Errors(log);
    private static final AtomicLong counter = new AtomicLong();
    private final BlobManager bm;
    private final BmResourceSecurity security;

    public BmResource() {
        this(BlobManagerLookup.get(), BmResourceSecurityLookup.get());
    }

    public BmResource(@Context BlobManager bm, @Context BmResourceSecurity security) {
        this.bm = bm;
        this.security = security;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="status")
    @Produces(value={"text/plain"})
    public String getStatus() {
        String string;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../bm/status", op));
        }
        try {
            this.getBM();
            string = "OK";
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="blob/{blobId}")
    @Produces(value={"application/octet-stream"})
    public Response getBlob(@PathParam(value="blobId") UUIDParam blobId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @HeaderParam(value="Range") ByteRangeHeaderParam rangeHeader) throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../bm/blob/%s", op, blobId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
        }
        try {
            response = this.doGetBlob(blobId, digest, rangeHeader, false);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="localBlob/{blobId}")
    @Produces(value={"application/octet-stream"})
    public Response getLocalBlob(@PathParam(value="blobId") UUIDParam blobId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @HeaderParam(value="Range") ByteRangeHeaderParam rangeHeader) throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../bm/localBlob/%s", op, blobId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
        }
        try {
            response = this.doGetBlob(blobId, digest, rangeHeader, true);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * Loose catch block
     */
    @POST
    @Path(value="addBlob")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"text/plain"})
    public Response addBlob(InputStream in, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest) throws Exception {
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] POST .../bm/addBlob", op));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
        }
        BlobManager bm = this.getBM();
        this.assertCanCreateBlob();
        MessageDigest dig = null;
        if (digest != null && (dig = digest.getDigest()) != null) {
            in = new HashCheckingInputStream(in, dig);
        }
        UUID id = bm.addBlob(in);
        URI location = UriBuilder.fromResource(BmResource.class).path(BmResource.class, "getBlob").build(new Object[]{id});
        Response.ResponseBuilder resb = Response.created((URI)location);
        resb.header("X-Codestation-Blob-ID", (Object)id.toString());
        Response response = resb.build();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
        {
            catch (Exception e) {
                try {
                    throw errors.mapException(e);
                }
                catch (Throwable throwable) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("[op=%d] Complete", op));
                    }
                    throw throwable;
                }
            }
        }
    }

    Response doGetBlob(UUIDParam blobIdParam, DigestParam digestHeader, ByteRangeHeaderParam rangeHeader, boolean localOnly) throws Exception {
        BlobManager bm = this.getBM();
        UUID blobId = blobIdParam.getUUID();
        this.assertCanReadBlob(blobId);
        try {
            Response.ResponseBuilder resb;
            MessageDigest digest = null;
            if (digestHeader != null) {
                digest = digestHeader.getDigest();
            }
            ByteRange range = this.getRange(rangeHeader);
            InputStream blob = localOnly ? bm.openBlobLocal(blobId) : bm.openBlob(blobId);
            if (blob == null) {
                throw errors.notFound("Blob not found: " + blobId);
            }
            long blobLength = this.getLength(blob);
            long rangeLength = -1L;
            if (range != null) {
                long rangeOffset = range.getAbsoluteOffset(blobLength);
                rangeLength = range.getAbsoluteLength(blobLength);
                blob = new SubRangeInputStream(blob, rangeOffset, rangeLength);
                digest = null;
            }
            if (digest != null) {
                blob = new HashInjectingInputStream(blob, digest);
            }
            if (range != null) {
                if (!range.isSatisfiable(blobLength)) {
                    throw errors.requestedRangeNotSatisfiable("Requested Range Not Satisfiable", blobLength);
                }
                resb = Response.status((int)206).entity((Object)blob);
                resb.header("Content-Range", (Object)ByteContentRange.forKnownLengthEntity(range.asSatisfiedRange(blobLength), blobLength));
                if (rangeLength != 1L) {
                    resb.header("Content-Length", (Object)rangeLength);
                }
            } else {
                resb = Response.ok((Object)blob);
                if (blobLength != -1L) {
                    long contentLength = blobLength;
                    if (digest != null) {
                        contentLength += (long)digest.getDigestLength();
                    }
                    resb.header("Content-Length", (Object)contentLength);
                }
            }
            resb.type(MediaType.APPLICATION_OCTET_STREAM_TYPE);
            resb.header("X-Codestation-Blob-ID", (Object)blobId.toString());
            resb.header("Accept-Ranges", (Object)"bytes");
            if (digest != null) {
                resb.header("X-Codestation-Digest-Algorithm", (Object)digest.getAlgorithm());
            }
            return resb.build();
        }
        catch (Exception e) {
            throw errors.mapException(e);
        }
    }

    private long getLength(InputStream blob) throws IOException {
        long length = -1L;
        if (blob instanceof SeekableInputStream) {
            length = ((SeekableInputStream)blob).length();
        }
        return length;
    }

    private ByteRange getRange(ByteRangeHeaderParam header) {
        List<ByteRange> ranges;
        ByteRange range = null;
        if (header != null && !(ranges = header.getRanges()).isEmpty()) {
            if (ranges.size() > 1) {
                throw errors.badRequest("Multiple byte ranges not supported");
            }
            range = ranges.get(0);
        }
        return range;
    }

    private BlobManager getBM() {
        if (this.bm == null) {
            throw errors.notImplemented("Blob manager unavailable");
        }
        return this.bm;
    }

    synchronized BmResourceSecurity getSecurity() {
        return this.security;
    }

    private synchronized void assertCanReadBlob(UUID blobId) {
        try {
            BmResourceSecurity security = this.getSecurity();
            if (security != null) {
                security.assertCanReadBlob(blobId);
            }
        }
        catch (CodestationSecurityException e) {
            throw errors.mapException(e);
        }
    }

    private synchronized void assertCanCreateBlob() {
        try {
            BmResourceSecurity security = this.getSecurity();
            if (security != null) {
                security.assertCanCreateBlob();
            }
        }
        catch (CodestationSecurityException e) {
            throw errors.mapException(e);
        }
    }
}

