/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.asm;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.asm.AsmConnector;
import com.ibm.uclab.csrepl.asm.AsmUsageEstimator;
import com.ibm.uclab.csrepl.asm.BackgroundSynchronizer;
import com.ibm.uclab.csrepl.asm.BlobCleanup;
import com.ibm.uclab.csrepl.asm.BlobReplication;
import com.ibm.uclab.csrepl.asm.security.AsmSecurity;
import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.lifecycle.Lifecycle;
import com.ibm.uclab.csrepl.lifecycle.LifecycleEventListener;
import com.ibm.uclab.csrepl.lifecycle.LifecycleThreadFactory;
import com.ibm.uclab.csrepl.ptrstore.IDMapping;
import com.ibm.uclab.csrepl.ptrstore.IDMappingReader;
import com.ibm.uclab.csrepl.ptrstore.PtrStore;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ArtifactSetManagerImpl
implements ArtifactSetManager {
    private static final Logger log = Logger.getLogger(ArtifactSetManagerImpl.class);
    private static final String SYNCHRONIZE_INTERVAL_KEY = "com.ibm.uclab.csrepl.asm.ArtifactSetManagerImpl.synchronizeInterval";
    private static final long SYNCHRONIZE_INTERVAL_DEFAULT = 3600000L;
    private static final String MAX_BG_REPLICATONS_KEY = "com.ibm.uclab.csrepl.blobstore.BlobStoreImpl.maxBackgroundReplications";
    private static final int MAX_BG_REPLICATONS_DEFAULT = 3;
    private final Lifecycle lifecycle = new Lifecycle(this, new LifecycleEventListener(){

        @Override
        public void onStart() {
            ArtifactSetManagerImpl.this.start0();
        }

        @Override
        public void onStop() {
            ArtifactSetManagerImpl.this.stop0();
        }
    });
    private final UUID id;
    private final PtrStore store;
    private final BlobManager bm;
    private final ExecutorService executor;
    private final ExecutorService throttledExecutor;
    private final Executor synchronousExecutor;
    private final long synchronizeInterval;
    private final Set<UUID> activeBackgroundReplications;
    private AsmConnector connector;
    private boolean replicationEnabled;
    private boolean backgroundSynchronizationEnabled;
    private Set<String> interestedGeoTags;
    private AsmSecurity security;

    public ArtifactSetManagerImpl(UUID id, PtrStore store, BlobManager bm) {
        this.id = id;
        this.store = store;
        this.bm = bm;
        LifecycleThreadFactory threadFactory = new LifecycleThreadFactory("ASM[" + id + "]-worker");
        this.executor = Executors.newCachedThreadPool((ThreadFactory)((Object)threadFactory));
        Integer maxBgReplications = Integer.getInteger(MAX_BG_REPLICATONS_KEY, 3);
        ThreadPoolExecutor pool = new ThreadPoolExecutor((int)maxBgReplications, (int)maxBgReplications, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)((Object)threadFactory));
        pool.allowCoreThreadTimeOut(true);
        this.throttledExecutor = pool;
        this.synchronousExecutor = new Executor(){

            @Override
            public void execute(Runnable r) {
                r.run();
            }
        };
        this.synchronizeInterval = Long.getLong(SYNCHRONIZE_INTERVAL_KEY, 3600000L);
        this.activeBackgroundReplications = Collections.synchronizedSet(new HashSet());
        this.replicationEnabled = true;
        this.backgroundSynchronizationEnabled = true;
        this.interestedGeoTags = Collections.emptySet();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id + "]";
    }

    @Override
    public void start() {
        this.lifecycle.start();
    }

    @Override
    public void stop() {
        this.lifecycle.stop();
    }

    public synchronized void setConnector(AsmConnector connector) {
        if (this.lifecycle.isStopped()) {
            throw new IllegalStateException("Stopped");
        }
        if (this.lifecycle.isStarted() && this.connector != null) {
            throw new IllegalStateException("Connector cannot change after start");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting connector: " + connector));
        }
        this.connector = connector;
        if (this.lifecycle.isStarted() && connector != null) {
            connector.start();
            this.startSynchronizingWithRemote();
        }
    }

    public synchronized Set<String> getInterestedGeoTags() {
        return Collections.unmodifiableSet(this.interestedGeoTags);
    }

    public synchronized void setInterestedGeoTags(Collection<String> interestedGeoTags) {
        if (this.lifecycle.isStopped()) {
            throw new IllegalStateException("Stopped");
        }
        if (this.lifecycle.isStarted() && interestedGeoTags != null) {
            throw new IllegalStateException("Tags cannot change after start");
        }
        Set tags = Collections.emptySet();
        if (interestedGeoTags != null) {
            tags = new HashSet<String>(interestedGeoTags);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting interested geo tags: " + interestedGeoTags));
        }
        this.interestedGeoTags = tags;
    }

    public synchronized AsmSecurity getSecurity() {
        return this.security;
    }

    public synchronized void setSecurity(AsmSecurity security) {
        if (this.lifecycle.isStopped()) {
            throw new IllegalStateException("Stopped");
        }
        if (this.lifecycle.isStarted() && this.security != null) {
            throw new IllegalStateException("Security cannot change after start");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting security: " + security));
        }
        this.security = security;
        if (this.lifecycle.isStarted() && security != null) {
            security.start();
        }
    }

    public synchronized void setReplicationEnabled(boolean replicationEnabled) {
        this.replicationEnabled = replicationEnabled;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public UUID getBlobId(UUID artifactSetId) throws IOException {
        AsmConnector c;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get-blob-ID: asid=" + artifactSetId));
        }
        if ((c = this.getConnector()) != null) {
            UUID blobId;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Get-blob-ID: using remote");
            }
            if ((blobId = c.getBlobId(this.id, artifactSetId)) == null) {
                this.removeBlobId0(artifactSetId, this.executor);
            } else {
                this.setBlobId0(artifactSetId, blobId);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Get-blob-ID result (remote): id=" + blobId));
            }
            return blobId;
        }
        UUID blobId = this.store.getBlobId(artifactSetId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get-blob-ID result (local): id=" + blobId));
        }
        return blobId;
    }

    @Override
    public void setBlobId(UUID artifactSetId, UUID blobId) throws IOException {
        if (this.getConnector() != null) {
            throw new UnsupportedOperationException("Local modification disabled");
        }
        this.setBlobId0(artifactSetId, blobId);
    }

    @Override
    public Set<String> getGeoTags(UUID artifactSetId) throws IOException {
        IDMapping m = this.store.getMapping(artifactSetId);
        if (m == null) {
            return Collections.emptySet();
        }
        return m.getGeoTags();
    }

    @Override
    public void setGeoTags(UUID artifactSetId, Collection<String> geoTags) throws IOException {
        IDMapping update;
        IDMapping expected;
        if (this.getConnector() != null) {
            throw new UnsupportedOperationException("Local modification disabled");
        }
        IDMapping mapping = this.store.getMapping(artifactSetId);
        if (mapping == null) {
            return;
        }
        while ((mapping = this.store.compareAndSetMapping(expected = mapping, update = mapping.withGeoTags(geoTags))) != null) {
        }
    }

    @Override
    public void removeBlobId(UUID artifactSetId) throws IOException {
        if (this.getConnector() != null) {
            return;
        }
        this.removeBlobId0(artifactSetId, this.executor);
    }

    @Override
    public UUID compareAndSetBlobId(UUID artifactSetId, UUID expectedBlobId, UUID updateBlobId) throws IOException {
        if (this.getConnector() != null) {
            throw new UnsupportedOperationException("Local modification disabled");
        }
        return this.compareAndSetBlobId0(artifactSetId, expectedBlobId, updateBlobId);
    }

    @Override
    public UUID compareAndRemoveBlobId(UUID artifactSetId, UUID expectedBlobId) throws IOException {
        if (this.getConnector() != null) {
            return null;
        }
        return this.compareAndRemoveBlobId0(artifactSetId, expectedBlobId, this.executor);
    }

    @Override
    public long estimateDiskUsage(UUID id) throws IOException {
        return new AsmUsageEstimator(log, this.store, this.bm).estimate(id);
    }

    @Override
    public IDMappingReader getMappingReader() throws IOException {
        AsmSecurity sec = this.getSecurity();
        if (sec != null) {
            sec.assertCanGetMappings();
        }
        return this.store.getMappingReader();
    }

    synchronized AsmConnector getConnector() {
        return this.connector;
    }

    boolean isCleanupEnabled() {
        return true;
    }

    synchronized boolean isReplicationEnabled() {
        return this.replicationEnabled;
    }

    synchronized boolean isBackgroundSynchronizationEnabled() {
        return this.backgroundSynchronizationEnabled;
    }

    synchronized void setBackgroundSynchronizationEnabled(boolean backgroundSynchronizationEnabled) {
        this.backgroundSynchronizationEnabled = backgroundSynchronizationEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void synchronizeWithRemote() throws IOException {
        IDMapping m;
        AsmConnector connector = this.getConnector();
        if (connector == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Synchronizing ptrstore with remote: " + connector));
        }
        HashSet<UUID> toRemove = new HashSet<UUID>();
        IDMappingReader reader = this.store.getMappingReader();
        try {
            while ((m = reader.read()) != null) {
                toRemove.add(m.getArtifactSetId());
            }
        }
        finally {
            reader.close();
        }
        reader = connector.getMappingReader(this.id);
        try {
            while ((m = reader.read()) != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Setting mapping: asid=%s, bid=%s", m.getArtifactSetId(), m.getBlobId()));
                }
                this.setMapping(m);
                toRemove.remove(m.getArtifactSetId());
            }
        }
        finally {
            reader.close();
        }
        for (UUID id : toRemove) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Removing mapping: asid=" + id));
            }
            this.removeBlobId0(id, this.synchronousExecutor);
        }
        if (this.isReplicationEnabled()) {
            Semaphore completed = new Semaphore(0);
            int queued = 0;
            reader = this.store.getMappingReader();
            try {
                IDMapping m2;
                while ((m2 = reader.read()) != null) {
                    String tag = this.getTagOfInterest(m2);
                    if (tag != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Artifact set %s has tag %s; replicating", m2.getArtifactSetId(), tag));
                        }
                        if (!this.replicateBlobs(m2.getArtifactSetId(), m2.getBlobId(), this.throttledExecutor, completed)) continue;
                        ++queued;
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("No tag of interest in %s; not replicating", m2.getArtifactSetId()));
                }
            }
            finally {
                reader.close();
            }
            try {
                completed.acquire(queued);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Synchronization complete");
        }
    }

    private void removeBlobId0(UUID artifactSetId, Executor exec) throws IOException {
        UUID expected;
        UUID id = null;
        while ((id = this.compareAndRemoveBlobId0(artifactSetId, expected = id, exec)) != null) {
        }
    }

    private void setBlobId0(UUID artifactSetId, UUID blobId) throws IOException {
        UUID expected;
        UUID id = null;
        while ((id = this.compareAndSetBlobId0(artifactSetId, expected = id, blobId)) != null) {
        }
    }

    private UUID compareAndSetBlobId0(UUID artifactSetId, UUID expectedBlobId, UUID updateBlobId) throws IOException {
        UUID id;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Compare-and-set-blob-ID: asid=%s, expected=%s, update=%s", artifactSetId, expectedBlobId, updateBlobId));
        }
        if ((id = this.store.compareAndSetBlobId(artifactSetId, expectedBlobId, updateBlobId)) == null) {
            this.cleanupBlobs(artifactSetId, expectedBlobId, updateBlobId, this.executor);
            this.replicateBlobs(artifactSetId, updateBlobId, this.executor, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Compare-and-set-blob-ID result: " + id));
        }
        return id;
    }

    private UUID compareAndRemoveBlobId0(UUID artifactSetId, UUID expectedBlobId, Executor exec) throws IOException {
        UUID id;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Compare-and-remove-blob-ID: asid=%s, expected=%s", artifactSetId, expectedBlobId));
        }
        if ((id = this.store.compareAndRemoveBlobId(artifactSetId, expectedBlobId)) == null) {
            this.cleanupBlobs(artifactSetId, expectedBlobId, null, exec);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Compare-and-remove-blob-ID result: " + id));
        }
        return id;
    }

    private void startSynchronizingWithRemote() {
        if (!this.isBackgroundSynchronizationEnabled()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting background synchronization thread");
        }
        this.executor.execute(new BackgroundSynchronizer(this, this.synchronizeInterval));
    }

    private void cleanupBlobs(UUID artifactSetId, UUID oldBlobId, UUID newBlobId, Executor exec) {
        if (!this.isCleanupEnabled()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Cleanup-blobs: asid=%s, old=%s, new=%s", artifactSetId, oldBlobId, newBlobId));
        }
        exec.execute(new BlobCleanup(this.bm, oldBlobId, newBlobId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replicateBlobs(UUID artifactSetId, final UUID newBlobId, Executor exec, final Semaphore completed) {
        if (!this.isReplicationEnabled()) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Replicate-blobs: asid=%s, new=%s", artifactSetId, newBlobId));
        }
        final BlobReplication br = new BlobReplication(this.bm, newBlobId);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        br.run();
                    }
                    finally {
                        ArtifactSetManagerImpl.this.activeBackgroundReplications.remove(newBlobId);
                    }
                }
                finally {
                    if (completed != null) {
                        completed.release();
                    }
                }
            }
        };
        Set<UUID> set = this.activeBackgroundReplications;
        synchronized (set) {
            if (!this.activeBackgroundReplications.add(newBlobId)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Skipping replication: already in progress: " + newBlobId));
                }
                return false;
            }
        }
        exec.execute(r);
        return true;
    }

    private void start0() {
        this.bm.start();
        this.store.start();
        if (this.security != null) {
            this.security.start();
        }
        if (this.connector != null) {
            this.connector.start();
            this.startSynchronizingWithRemote();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": started"));
        }
    }

    private void stop0() {
        if (this.connector != null) {
            this.connector.stop();
        }
        this.executor.shutdownNow();
        if (this.security != null) {
            this.security.stop();
        }
        this.store.stop();
        this.bm.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": stopped"));
        }
    }

    private void setMapping(IDMapping update) throws IOException {
        IDMapping mapping = null;
        do {
            IDMapping expected;
            if ((mapping = this.store.compareAndSetMapping(expected = mapping, update)) != null || expected == null) continue;
            UUID asid = expected.getArtifactSetId();
            this.cleanupBlobs(asid, expected.getBlobId(), update.getBlobId(), this.synchronousExecutor);
        } while (mapping != null);
    }

    private String getTagOfInterest(IDMapping mapping) {
        Set<String> tags = mapping.getGeoTags();
        if (tags.contains("*") || this.interestedGeoTags.contains("*")) {
            return "*";
        }
        for (String t : this.interestedGeoTags) {
            if (!tags.contains(t)) continue;
            return "t";
        }
        return null;
    }
}

