/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.client.ops;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.Download;
import com.ibm.uclab.csrepl.client.ops.VerifyResult;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.codestation.Filter;
import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class Sync
extends Download {
    private static final Logger log = Logger.getLogger(Sync.class);
    protected Map<String, FileMetadata> path2meta = new HashMap<String, FileMetadata>();
    protected Map<String, UUID> path2version = new HashMap<String, UUID>();
    protected Map<UUID, List<FileMetadata>> downloadList = new HashMap<UUID, List<FileMetadata>>();
    protected UUID downloadId;
    protected Filter downloadFilter;

    Sync(CodestationClient client, File destination, List<UUID> artifactSetIds) {
        super(client, destination, artifactSetIds);
    }

    @Override
    public void run() throws IOException {
        this.collectMeta();
        this.clean();
        this.scan();
        this.downloadFiles();
    }

    protected void collectMeta() throws IOException {
        Filter filter = this.getMetadataDownloadFilter();
        for (UUID id : this.artifactSetIds) {
            log.info((Object)("Downloading metadata for artifact set " + id + "."));
            List<FileMetadata> meta = this.client.getMetadata(id, filter);
            for (FileMetadata m : meta) {
                String p = this.stripSourcePathOffset(m.getPath());
                this.path2meta.put(p, m);
                this.path2version.put(p, id);
            }
        }
    }

    protected void clean() throws IOException {
        log.info((Object)"Removing unnecessary files.");
        FileListerBuilder flb = new FileListerBuilder(this.destination);
        flb.directories(FileListerBuilder.Directories.INCLUDE_ALL);
        flb.symlinks(FileListerBuilder.Symlinks.AS_LINK);
        flb.permissions(FileListerBuilder.Permissions.NONE);
        List files = flb.build().list();
        for (TypedFile f : files) {
            File file = f.translate(this.destination);
            FileMetadata meta = this.path2meta.get(f.path());
            if (meta != null) continue;
            this.delete(file);
        }
    }

    protected void scan() throws IOException {
        log.info((Object)"Scanning for differences.");
        for (Map.Entry<String, FileMetadata> entry : this.path2meta.entrySet()) {
            String path = entry.getKey();
            FileMetadata meta = entry.getValue();
            UUID id = this.path2version.get(path);
            File file = this.toFile(meta);
            VerifyResult r = this.verify(file, meta);
            if (r.isOK()) {
                log.info((Object)("Success: " + r.getPath()));
                continue;
            }
            log.info((Object)("Fail: " + r.getMessage() + ": " + r.getPath()));
            if (r.getDetail() != null) {
                log.info((Object)("      " + r.getDetail()));
            }
            log.info((Object)"      queueing for download");
            this.queueDownload(id, meta);
        }
        if (!this.downloadList.isEmpty()) {
            log.info((Object)"Removing different files.");
            for (List list : this.downloadList.values()) {
                for (FileMetadata m : list) {
                    File f = this.toFile(m);
                    if (!f.exists()) continue;
                    this.delete(f);
                }
            }
        }
    }

    @Override
    protected void downloadFiles() throws IOException {
        System.out.println();
        if (this.downloadList.isEmpty()) {
            log.info((Object)"File download not required.");
            return;
        }
        for (Map.Entry<UUID, List<FileMetadata>> e : this.downloadList.entrySet()) {
            UUID id = e.getKey();
            ArrayList<String> paths = new ArrayList<String>();
            for (FileMetadata m : e.getValue()) {
                paths.add(m.getPath());
            }
            log.info((Object)("Downloading files from artifact set " + id));
            this.downloadId = id;
            this.downloadFilter = Filter.compile(paths, null);
            if (this.downloadFilter.getIncludes().isEmpty()) continue;
            super.downloadFiles();
            System.out.println();
        }
        log.info((Object)"All files downloaded.");
    }

    @Override
    protected Filter getFileDownloadFilter() {
        return this.downloadFilter;
    }

    @Override
    protected UUID getFileDownloadArtifactSetId() {
        return this.downloadId;
    }

    protected void queueDownload(UUID versionId, FileMetadata meta) {
        List<FileMetadata> metas = this.downloadList.get(versionId);
        if (metas == null) {
            metas = new ArrayList<FileMetadata>();
            this.downloadList.put(versionId, metas);
        }
        metas.add(meta);
    }
}

