/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.asm;

import com.ibm.uclab.csrepl.asm.AsmConnector;
import com.ibm.uclab.csrepl.asm.IDMappingReaderBufferedReader;
import com.ibm.uclab.csrepl.exceptions.AuthenticationException;
import com.ibm.uclab.csrepl.exceptions.CodestationSecurityException;
import com.ibm.uclab.csrepl.exceptions.Errors;
import com.ibm.uclab.csrepl.http.HttpClientWrapper;
import com.ibm.uclab.csrepl.lifecycle.Lifecycle;
import com.ibm.uclab.csrepl.lifecycle.LifecycleEventListener;
import com.ibm.uclab.csrepl.ptrstore.IDMappingReader;
import com.ibm.uclab.csrepl.streams.AbortingInputStream;
import com.urbancode.commons.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class AsmConnectorHttp
implements AsmConnector {
    private static final Logger log = Logger.getLogger(AsmConnectorHttp.class);
    private static final Errors errors = new Errors(log);
    private final Lifecycle lifecycle;
    private final HttpClientWrapper client;
    private final String peerUrl;

    public AsmConnectorHttp(HttpClientWrapper client, String peerUrl) {
        while (peerUrl.endsWith("/")) {
            peerUrl = peerUrl.substring(0, peerUrl.length() - 1);
        }
        this.lifecycle = new Lifecycle(this, new LifecycleEventListener(){

            @Override
            public void onStart() {
                AsmConnectorHttp.this.start0();
            }

            @Override
            public void onStop() {
                AsmConnectorHttp.this.stop0();
            }
        });
        this.client = client;
        this.peerUrl = peerUrl;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.peerUrl + "]";
    }

    @Override
    public UUID getBlobId(UUID localId, UUID artifactSetId) throws IOException {
        String reqUrl = this.peerUrl + "/asm/artifactSet/" + artifactSetId.toString();
        HttpGet req = new HttpGet(reqUrl);
        req.setHeader("X-Codestation-Client-ID", localId.toString());
        HttpResponse res = this.client.execute((HttpUriRequest)req);
        try {
            StatusLine status = res.getStatusLine();
            switch (status.getStatusCode()) {
                case 200: {
                    UUID blobId;
                    String s = EntityUtils.toString((HttpEntity)res.getEntity());
                    try {
                        blobId = UUID.fromString(s);
                    }
                    catch (IllegalArgumentException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Request succeeded but with an invalid ID: %s: %03d %s: %s", req.getURI(), status.getStatusCode(), status.getReasonPhrase(), s));
                        }
                        UUID uUID = null;
                        EntityUtils.consumeQuietly((HttpEntity)res.getEntity());
                        return uUID;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Request succeeded with an ID: %s: %03d %s: %s", req.getURI(), status.getStatusCode(), status.getReasonPhrase(), blobId));
                    }
                    UUID uUID = blobId;
                    return uUID;
                }
                case 404: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Request yielded no ID: %s: %03d %s", req.getURI(), status.getStatusCode(), status.getReasonPhrase()));
                    }
                    UUID uUID = null;
                    return uUID;
                }
                case 401: {
                    throw this.unauthorized(res, "GET", reqUrl);
                }
            }
            throw errors.defaultArtifactSetErrorSwitch(artifactSetId, new Errors.CallResult("GET", reqUrl, (HttpRequestBase)req, res));
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)res.getEntity());
        }
    }

    @Override
    public IDMappingReader getMappingReader(UUID localId) throws IOException {
        String reqUrl = this.peerUrl + "/asm/mappings";
        HttpGet req = new HttpGet(reqUrl);
        req.setHeader("X-Codestation-Client-ID", localId.toString());
        boolean consumeEntity = true;
        HttpResponse res = this.client.execute((HttpUriRequest)req);
        try {
            StatusLine status = res.getStatusLine();
            switch (status.getStatusCode()) {
                case 200: {
                    HttpEntity ent = res.getEntity();
                    InputStream in = null;
                    Charset cs = null;
                    if (ent != null) {
                        in = ent.getContent();
                        cs = this.getCharset(ent);
                    }
                    if (ent == null || in == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Request succeeded without content: %s: %03d %s", req.getURI(), status.getStatusCode(), status.getReasonPhrase()));
                        }
                        IDMappingReaderBufferedReader iDMappingReaderBufferedReader = new IDMappingReaderBufferedReader(null);
                        return iDMappingReaderBufferedReader;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Request succeeded with content: %s: %03d %s", req.getURI(), status.getStatusCode(), status.getReasonPhrase()));
                    }
                    in = new AbortingInputStream((HttpRequestBase)req, in);
                    IDMappingReaderBufferedReader reader = new IDMappingReaderBufferedReader(IO.buffer((Reader)IO.reader((InputStream)in, (Charset)cs)));
                    consumeEntity = false;
                    IDMappingReaderBufferedReader iDMappingReaderBufferedReader = reader;
                    return iDMappingReaderBufferedReader;
                }
                case 401: {
                    throw this.unauthorized(res, "GET", reqUrl);
                }
                case 403: {
                    throw this.forbidden(res, "GET", reqUrl);
                }
                case 404: {
                    throw this.serviceNotFound(res, "GET", reqUrl);
                }
            }
            throw errors.defaultArtifactSetErrorSwitch(null, new Errors.CallResult("GET", reqUrl, (HttpRequestBase)req, res));
        }
        finally {
            if (consumeEntity) {
                EntityUtils.consumeQuietly((HttpEntity)res.getEntity());
            }
        }
    }

    @Override
    public void start() {
        this.lifecycle.start();
    }

    @Override
    public void stop() {
        this.lifecycle.stop();
    }

    private void start0() {
        this.client.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": started"));
        }
    }

    private void stop0() {
        this.client.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": stopped"));
        }
    }

    private Charset getCharset(HttpEntity ent) {
        Header ct = ent.getContentType();
        if (ct == null) {
            return IO.utf8();
        }
        HeaderElement[] els = ct.getElements();
        if (els == null || els.length == 0) {
            return IO.utf8();
        }
        NameValuePair nv = els[0].getParameterByName("charset");
        if (nv == null) {
            return IO.utf8();
        }
        String v = nv.getValue();
        if (v == null) {
            return IO.utf8();
        }
        return Charset.forName(v);
    }

    private IOException serviceNotFound(HttpResponse res, String method, String reqUrl) {
        String error = this.getErrorMessage(res);
        error = error == null ? "" : ": " + error;
        StatusLine status = res.getStatusLine();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Request failed with not found: %s %s: %03d %s%s", method, reqUrl, status.getStatusCode(), status.getReasonPhrase(), error));
        }
        return new IOException(String.format("Remote service not found: %s %s%n", method, reqUrl));
    }

    private AuthenticationException unauthorized(HttpResponse res, String method, String reqUrl) {
        String error = this.getErrorMessage(res);
        error = error == null ? "" : ": " + error;
        StatusLine status = res.getStatusLine();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Unacceptable response: %s %s: %03d %s%s", method, reqUrl, status.getStatusCode(), status.getReasonPhrase(), error));
        }
        return new AuthenticationException("Cannot authenticate with server: " + reqUrl);
    }

    private CodestationSecurityException forbidden(HttpResponse res, String method, String reqUrl) {
        String error = this.getErrorMessage(res);
        error = error == null ? "" : ": " + error;
        StatusLine status = res.getStatusLine();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Unacceptable response: %s %s: %03d %s%s", method, reqUrl, status.getStatusCode(), status.getReasonPhrase(), error));
        }
        return new CodestationSecurityException("Access denied: " + reqUrl);
    }

    private String getErrorMessage(HttpResponse res) {
        try {
            HttpEntity ent = res.getEntity();
            if (ent == null) {
                return null;
            }
            Header hd = ent.getContentType();
            if (hd == null) {
                return null;
            }
            String val = hd.getValue();
            if (val == null) {
                return null;
            }
            ContentType ct = ContentType.parse((String)val);
            if (ct == null) {
                return null;
            }
            if (!"text/plain".equalsIgnoreCase(ct.getMimeType())) {
                return null;
            }
            return EntityUtils.toString((HttpEntity)ent);
        }
        catch (ParseException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

