/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.moveable;

import com.ibm.uclab.csrepl.moveable.MoveableFileInputStream;
import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStream;
import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStreams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

class MoveableFileInputStreamNonPosix
extends MoveableFileInputStream {
    private static final Logger log = Logger.getLogger(MoveableFileInputStreamNonPosix.class);
    private final ReentrantReadWriteLock lock;
    private SeekableInputStream in;
    private boolean broken;
    private boolean closed;
    private long pos;

    MoveableFileInputStreamNonPosix(File file) throws FileNotFoundException {
        this.in = SeekableInputStreams.adapt((RandomAccessFile)new RandomAccessFile(file, "r"));
        this.lock = new ReentrantReadWriteLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        this.preRead();
        try {
            int n = this.in.read();
            return n;
        }
        finally {
            this.postRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        this.preRead();
        try {
            int n = this.in.read(b, off, len);
            return n;
        }
        finally {
            this.postRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.preRead();
        try {
            this.closed = true;
            this.in.close();
        }
        finally {
            this.postRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) throws IOException {
        this.preRead();
        try {
            long l = this.in.skip(n);
            return l;
        }
        finally {
            this.postRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seek(long position) throws IOException {
        this.preRead();
        try {
            this.in.seek(position);
        }
        finally {
            this.postRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position() throws IOException {
        this.preRead();
        try {
            long l = this.in.position();
            return l;
        }
        finally {
            this.postRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        this.preRead();
        try {
            int n = this.in.available();
            return n;
        }
        finally {
            this.postRead();
        }
    }

    public long length() throws IOException {
        return this.in.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preMove() throws IOException {
        this.lock.writeLock().lock();
        boolean ok = false;
        try {
            if (!this.closed) {
                this.pos = this.in.position();
                this.in.close();
            }
            ok = true;
        }
        finally {
            if (!ok) {
                this.broken = true;
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postMove(File newFile) {
        boolean ok = false;
        try {
            if (newFile != null) {
                if (!this.closed) {
                    this.in = SeekableInputStreams.adapt((RandomAccessFile)new RandomAccessFile(newFile, "r"));
                    this.in.seek(this.pos);
                }
                ok = true;
            }
            this.broken = !ok;
        }
        catch (IOException e) {
            try {
                log.error((Object)"File broken", (Throwable)e);
                this.broken = !ok;
            }
            catch (Throwable throwable) {
                this.broken = !ok;
                this.lock.writeLock().unlock();
                throw throwable;
            }
            this.lock.writeLock().unlock();
        }
        this.lock.writeLock().unlock();
    }

    @Override
    SeekableInputStream getIn() {
        return this.in;
    }

    boolean awaitLockQueueLength(int len, long millis) throws InterruptedException {
        int qlen;
        long waitStart = System.currentTimeMillis();
        while ((qlen = this.lock.getQueueLength()) < len && millis > 0L) {
            long t = Math.min(millis, 20L);
            Thread.sleep(t);
            long now = System.currentTimeMillis();
            millis -= now - waitStart;
            waitStart = now;
        }
        return qlen >= len;
    }

    private void preRead() throws IOException {
        this.lock.readLock().lock();
        if (this.broken) {
            this.lock.readLock().unlock();
            throw new IOException("file broken during move");
        }
    }

    private void postRead() {
        this.lock.readLock().unlock();
    }
}

