/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.client.ops;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.VerifyResult;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.codestation.Filter;
import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

abstract class DownloadBase {
    private static final Logger log = Logger.getLogger(DownloadBase.class);
    protected CodestationClient client;
    protected File destination;
    protected List<UUID> artifactSetIds;
    protected List<String> includes;
    protected List<String> excludes;
    protected String sourcePathOffset;
    protected List<FileMetadata> meta;
    protected MessageDigest dig;
    protected boolean slowVerification;
    protected String strippingPrefix;

    static String stripPathPrefix(String path, String prefix) {
        if (path == null || prefix == null) {
            return path;
        }
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if (!path.startsWith(prefix)) {
            return path;
        }
        return path.substring(prefix.length());
    }

    DownloadBase(CodestationClient client, File destination, List<UUID> artifactSetIds) {
        if (client == null) {
            throw new NullPointerException();
        }
        if (destination == null) {
            throw new NullPointerException();
        }
        if (artifactSetIds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.client = client;
        this.destination = destination;
        this.artifactSetIds = artifactSetIds;
    }

    public void setIncludes(List<String> includes) {
        if (includes != null) {
            includes = new ArrayList<String>(includes);
        }
        this.includes = includes;
    }

    public void setExcludes(List<String> excludes) {
        if (excludes != null) {
            excludes = new ArrayList<String>(excludes);
        }
        this.excludes = excludes;
    }

    public void setSourcePathOffset(String sourcePathOffset) {
        if (sourcePathOffset != null && (sourcePathOffset = sourcePathOffset.trim()).length() == 0) {
            sourcePathOffset = null;
        }
        this.sourcePathOffset = sourcePathOffset;
        if (sourcePathOffset != null) {
            this.strippingPrefix = FileMetadata.sanitizePath(sourcePathOffset) + "/";
        }
    }

    public void setSlowVerification(boolean slowVerification) {
        this.slowVerification = slowVerification;
    }

    public abstract void run() throws IOException;

    protected Filter getMetadataDownloadFilter() {
        return Filter.compile(this.includes, this.excludes).withPrefix(this.sourcePathOffset);
    }

    protected void downloadMetadata() throws IOException {
        Filter filter = this.getMetadataDownloadFilter();
        this.meta = new ArrayList<FileMetadata>();
        for (UUID id : this.artifactSetIds) {
            log.info((Object)("Downloading metadata for artifact set " + id + "."));
            this.meta.addAll(this.client.getMetadata(id, filter));
            log.info((Object)"Download complete.");
        }
    }

    protected boolean isSameType(File f, FileMetadata m) throws IOException {
        FileMetadata.Type ft = this.getMetadataType(f);
        return m.getType() == ft;
    }

    protected VerifyResult verify(File f, FileMetadata m) throws IOException {
        byte[] actual;
        FileMetadata.Type ft;
        String path = this.stripSourcePathOffset(m.getPath());
        if (!f.exists()) {
            return VerifyResult.pathMissing(path);
        }
        long len = f.length();
        if (m.getType() == FileMetadata.Type.FILE && len != m.getLength()) {
            return VerifyResult.lengthChanged(path, m.getLength(), len);
        }
        if (!this.slowVerification) {
            long lm = f.lastModified();
            if (m.getLastModified() != 0L && lm != m.getLastModified()) {
                return VerifyResult.lastModifiedChanged(path, lm, m.getLastModified());
            }
        }
        if ((ft = this.getMetadataType(f)) != m.getType()) {
            return VerifyResult.typeChanged(path, m.getType(), ft);
        }
        if (!this.slowVerification) {
            return VerifyResult.ok(path);
        }
        if (!f.isFile() || FileUtils.isSymlink((File)f)) {
            return VerifyResult.ok(path);
        }
        if (m.getHash() == null) {
            return VerifyResult.hashMissing(path);
        }
        byte[] expected = this.hashToBytes(m.getHash());
        if (!Arrays.equals(expected, actual = this.hashFile(f))) {
            String hash = Hex.encodeHexString((byte[])actual);
            return VerifyResult.hashChanged(path, m.getHash(), hash);
        }
        return VerifyResult.ok(path);
    }

    protected File toFile(FileMetadata m) {
        String p = this.stripSourcePathOffset(m.getPath());
        return new File(this.destination, p);
    }

    protected String stripSourcePathOffset(String path) {
        return DownloadBase.stripPathPrefix(path, this.strippingPrefix);
    }

    private byte[] hashToBytes(String hash) {
        if (hash.length() != 64) {
            throw new RuntimeException("Invalid SHA-256 hash: " + hash);
        }
        try {
            return Hex.decodeHex((char[])hash.toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException("Invalid SHA-256 hash: " + hash, e);
        }
    }

    private byte[] hashFile(File f) throws IOException {
        if (this.dig == null) {
            this.dig = IO.sha256Digester();
        }
        this.dig.reset();
        IO.digest((File)f, (MessageDigest)this.dig);
        return this.dig.digest();
    }

    private FileMetadata.Type getMetadataType(File f) throws IOException {
        if (FileUtils.isSymlink((File)f)) {
            return FileMetadata.Type.SYMLINK;
        }
        if (f.isDirectory()) {
            return FileMetadata.Type.DIRECTORY;
        }
        return FileMetadata.Type.FILE;
    }

    protected void delete(File file) throws IOException {
        log.info((Object)("Deleting: " + file.getAbsolutePath()));
        file.delete();
        File[] list = file.listFiles();
        if (list != null) {
            for (File f : list) {
                this.delete(f);
            }
            file.delete();
        }
    }

    protected boolean isSameType(TypedFile f, FileMetadata m) {
        switch (f.type()) {
            case REGULAR: {
                if (m.getType() == FileMetadata.Type.FILE) break;
                return false;
            }
            case DIRECTORY: {
                if (m.getType() == FileMetadata.Type.DIRECTORY) break;
                return false;
            }
            case SYMLINK: {
                if (m.getType() == FileMetadata.Type.SYMLINK) break;
                return false;
            }
            default: {
                throw new RuntimeException("Missing case: " + f.type());
            }
        }
        return true;
    }
}

