/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.bm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class BlobTable {
    private Map<UUID, Set<UUID>> blob2peer;

    public BlobTable(final int maxSize) {
        if (maxSize <= 0 || maxSize == Integer.MAX_VALUE) {
            this.blob2peer = new HashMap<UUID, Set<UUID>>();
        } else {
            int initCap = 16;
            float loadFactor = 0.75f;
            boolean lru = true;
            this.blob2peer = new LinkedHashMap<UUID, Set<UUID>>(initCap, loadFactor, lru){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<UUID, Set<UUID>> eldest) {
                    return this.size() > maxSize;
                }
            };
        }
    }

    public synchronized void setPeerHasBlob(UUID peerId, UUID blobId) {
        Set<UUID> set = this.blob2peer.get(blobId);
        if (set == null) {
            set = new HashSet<UUID>();
            this.blob2peer.put(blobId, set);
        }
        set.add(peerId);
    }

    public synchronized List<UUID> getPeersWithBlob(UUID blobId) {
        Set<UUID> set = this.blob2peer.get(blobId);
        if (set == null) {
            return new ArrayList<UUID>();
        }
        return new ArrayList<UUID>(set);
    }

    public synchronized void setPeerDoesNotHaveBlob(UUID peerId, UUID blobId) {
        Set<UUID> set = this.blob2peer.get(blobId);
        if (set == null) {
            return;
        }
        set.remove(peerId);
        if (set.isEmpty()) {
            this.blob2peer.remove(blobId);
        }
    }
}

