/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate.streams;

import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStream;
import java.io.IOException;
import java.io.InputStream;

final class SeekableInputStreamIS
extends SeekableInputStream {
    private final InputStream in;
    private final long length;
    private long readPosition;
    private long seekPosition;

    SeekableInputStreamIS(InputStream in, long length) {
        if (length < -1L) {
            throw new IllegalArgumentException("invalid length: " + length);
        }
        this.in = in;
        this.length = length;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void seek(long position) throws IOException {
        if (position < 0L) {
            throw new IOException("Invalid seek position: " + position);
        }
        this.seekPosition = position;
    }

    @Override
    public synchronized long position() throws IOException {
        return this.seekPosition;
    }

    @Override
    public long length() throws IOException {
        return this.length;
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.trySynchronizeReadPositionAndSeekPosition()) {
            return -1;
        }
        assert (this.readPosition == this.seekPosition);
        int n = this.in.read();
        if (n > -1) {
            ++this.readPosition;
            ++this.seekPosition;
        }
        return n;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (!this.trySynchronizeReadPositionAndSeekPosition()) {
            return -1;
        }
        assert (this.readPosition == this.seekPosition);
        int n = this.in.read(b, off, len);
        if (n > 0) {
            this.readPosition += (long)n;
            this.seekPosition += (long)n;
        }
        return n;
    }

    private boolean trySynchronizeReadPositionAndSeekPosition() throws IOException {
        if (this.seekPosition < this.readPosition) {
            throw new IOException("Seek before last byte read not supported");
        }
        if (this.seekPosition > this.readPosition) {
            this.advanceReadPositionToSeekPosition();
            if (this.seekPosition > this.readPosition) {
                return false;
            }
        }
        return true;
    }

    private void advanceReadPositionToSeekPosition() throws IOException {
        if (this.seekPosition > this.readPosition) {
            long n;
            long prevN = -1L;
            for (long len = this.seekPosition - this.readPosition; len > 0L; len -= n) {
                n = this.in.skip(len);
                this.readPosition += n;
                if (n == 0L && prevN == 0L) break;
                prevN = n;
            }
        }
    }
}

