/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.http;

import com.ibm.uclab.csrepl.http.HttpContextProvider;
import com.ibm.uclab.csrepl.http.NullHttpContextProvider;
import com.ibm.uclab.csrepl.lifecycle.Lifecycle;
import com.ibm.uclab.csrepl.lifecycle.LifecycleEventListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class HttpClientWrapper {
    private static final Logger log = Logger.getLogger(HttpClientWrapper.class);
    private static final String CONN_TIMEOUT_KEY = "com.ibm.uclab.csrepl.http.HttpClientWrapper.connectionTimeout";
    private static final int CONN_TIMEOUT_DEFAULT = 5000;
    private static final String SO_TIMEOUT_KEY = "com.ibm.uclab.csrepl.http.HttpClientWrapper.socketTimout";
    private static final int SO_TIMEOUT_DEFAULT = 30000;
    private final Lifecycle lifecycle = new Lifecycle(this, new LifecycleEventListener(){

        @Override
        public void onStart() {
            HttpClientWrapper.this.start0();
        }

        @Override
        public void onStop() {
            HttpClientWrapper.this.stop0();
        }
    });
    private final DefaultHttpClient client;
    private final HttpContextProvider contextProvider;
    private final Object poolExhaustionDiagnosticLock;
    private long poolExhaustionDiagnosticLastLogged;

    public HttpClientWrapper(DefaultHttpClient client) {
        this(client, null);
    }

    public HttpClientWrapper(DefaultHttpClient client, HttpContextProvider contextProvider) {
        this.client = client;
        if (contextProvider == null) {
            contextProvider = new NullHttpContextProvider();
        }
        this.contextProvider = contextProvider;
        this.poolExhaustionDiagnosticLock = new Object();
        int connTimeout = Integer.getInteger(CONN_TIMEOUT_KEY, 5000);
        int soTimeout = Integer.getInteger(SO_TIMEOUT_KEY, 30000);
        if (connTimeout < 0) {
            connTimeout = 5000;
        }
        if (soTimeout < 0) {
            soTimeout = 30000;
        }
        this.setTimeout0(connTimeout, soTimeout);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public DefaultHttpClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute(HttpUriRequest req) throws IOException, ClientProtocolException {
        DefaultHttpClient client;
        if (req == null) {
            throw new NullPointerException("req");
        }
        HttpClientWrapper httpClientWrapper = this;
        synchronized (httpClientWrapper) {
            if (!this.lifecycle.isActive()) {
                throw new IllegalStateException();
            }
            client = this.getClient();
        }
        try {
            HttpClientContext context = this.contextProvider.get(req);
            return client.execute(req, (HttpContext)context);
        }
        catch (ConnectionPoolTimeoutException e) {
            if (log.isDebugEnabled()) {
                this.logPoolExhaustionDiagnostic(e);
            }
            throw this.enhanceMessageWithPoolStats(e);
        }
    }

    public synchronized void setTimeout(int connectionTimeout, int socketTimeout) {
        if (this.lifecycle.isStarted()) {
            throw new IllegalStateException();
        }
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException("Invalid connection timeout: " + connectionTimeout);
        }
        if (socketTimeout < 0) {
            throw new IllegalArgumentException("Invalid socket timeout: " + socketTimeout);
        }
        this.setTimeout0(connectionTimeout, socketTimeout);
    }

    public synchronized void addCredentials(AuthScope scope, Credentials credentials) {
        if (this.lifecycle.isActive()) {
            throw new IllegalStateException();
        }
        this.client.getCredentialsProvider().setCredentials(scope, credentials);
    }

    public void start() {
        this.lifecycle.start();
    }

    public void stop() {
        this.lifecycle.stop();
    }

    private void setTimeout0(int connectionTimeout, int socketTimeout) {
        HttpParams params = this.client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)socketTimeout);
    }

    private void start0() {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": started"));
        }
    }

    private void stop0() {
        if (this.client != null) {
            HttpClientUtils.closeQuietly((HttpClient)this.client);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": stopped"));
        }
    }

    private ConnectionPoolTimeoutException enhanceMessageWithPoolStats(ConnectionPoolTimeoutException e) {
        String msg = e.getMessage() + ": timeout=" + this.getConnectionLeaseTimeout();
        HttpHost host = e.getHost();
        PoolStats totalStats = this.getTotalPoolStats();
        PoolStats routeStats = this.getRoutePoolStats(host);
        if (totalStats != null) {
            msg = msg + "; totalStats=" + totalStats;
        }
        if (routeStats != null) {
            msg = msg + "; routeStats[" + host + "]=" + routeStats;
        }
        ConnectionPoolTimeoutException ex = new ConnectionPoolTimeoutException(msg);
        ex.initCause((Throwable)e);
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logPoolExhaustionDiagnostic(ConnectionPoolTimeoutException cause) {
        int frequencySecs = 60;
        Object object = this.poolExhaustionDiagnosticLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (now - this.poolExhaustionDiagnosticLastLogged < (long)(frequencySecs * 1000)) {
                return;
            }
            this.poolExhaustionDiagnosticLastLogged = now;
        }
        Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
        ArrayList<Thread> threads = new ArrayList<Thread>(all.keySet());
        Collections.sort(threads, new Comparator<Thread>(){

            @Override
            public int compare(Thread o1, Thread o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        HttpHost host = null;
        if (cause != null) {
            host = cause.getHost();
        }
        PoolStats totalStats = this.getTotalPoolStats();
        PoolStats routeStats = this.getRoutePoolStats(host);
        String NL = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP POOL DIAGNOSTIC: Logging diagnostic info. This is logged at most once every ");
        sb.append(frequencySecs).append(" seconds.").append(NL);
        sb.append("\tConnection lease timeout: ").append(this.getConnectionLeaseTimeout()).append(NL);
        if (totalStats != null) {
            sb.append("\tTotal pool stats: ").append(totalStats).append(NL);
        }
        if (routeStats != null) {
            sb.append("\tRoute pool stats [").append(host).append("]: ").append(routeStats).append(NL);
        }
        if (!threads.isEmpty()) {
            sb.append("\tActive threads:").append(NL);
            for (Thread t : threads) {
                sb.append("\t").append(t.getName()).append(": ").append((Object)t.getState()).append(NL);
                for (StackTraceElement el : all.get(t)) {
                    sb.append("\t\tat ").append(el).append(NL);
                }
            }
        }
        if (cause != null) {
            List<String> lines = this.readExceptionTrace(cause);
            sb.append("\tLog event caused by:").append(NL);
            for (String line : lines) {
                sb.append("\t").append(line).append(NL);
            }
        }
        sb.setLength(sb.length() - NL.length());
        log.debug((Object)sb.toString());
    }

    private PoolStats getTotalPoolStats() {
        ClientConnectionManager cm = this.client.getConnectionManager();
        if (cm instanceof PoolingClientConnectionManager) {
            PoolingClientConnectionManager pcm = (PoolingClientConnectionManager)cm;
            return pcm.getTotalStats();
        }
        return null;
    }

    private PoolStats getRoutePoolStats(HttpHost host) {
        if (host == null) {
            return null;
        }
        ClientConnectionManager cm = this.client.getConnectionManager();
        if (cm instanceof PoolingClientConnectionManager) {
            PoolingClientConnectionManager pcm = (PoolingClientConnectionManager)cm;
            return pcm.getStats(new HttpRoute(host));
        }
        return null;
    }

    private int getConnectionLeaseTimeout() {
        HttpParams params = this.client.getParams();
        if (params == null) {
            return 0;
        }
        return HttpConnectionParams.getConnectionTimeout((HttpParams)params);
    }

    private List<String> readExceptionTrace(Throwable t) {
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            t.printStackTrace(printWriter);
            printWriter.flush();
            BufferedReader reader = new BufferedReader(new StringReader(writer.toString()));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            return Collections.unmodifiableList(lines);
        }
        catch (IOException swallow) {
            return Collections.emptyList();
        }
    }
}

