/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.streams;

import com.ibm.uclab.csrepl.exceptions.CorruptStreamException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Formatter;

public class HashCheckingInputStream
extends InputStream {
    static final int BUFFER_SIZE = 8192;
    private final InputStream in;
    private final MessageDigest dig;
    private final int digLen;
    private final byte[] buf;
    private byte[] receivedHash;
    private byte[] actualHash;
    private byte[] one;
    private IOException corruption;
    private volatile boolean closed;
    private int bufPos;
    private int bufSafe;
    private int bufLen;

    public HashCheckingInputStream(InputStream in, MessageDigest dig) {
        this.in = in;
        this.dig = dig;
        this.digLen = dig.getDigestLength();
        int len = 8192;
        if (this.digLen > 8192) {
            len = 2 * this.digLen;
        }
        this.buf = new byte[len];
        this.checkInvariants();
    }

    @Override
    public synchronized int read() throws IOException {
        int n;
        if (this.one == null) {
            this.one = new byte[1];
        }
        if ((n = this.read(this.one, 0, 1)) < 0) {
            return n;
        }
        return this.one[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || b.length - off < len) {
            throw new IndexOutOfBoundsException();
        }
        this.checkClosed();
        this.checkCorrupted();
        this.checkInvariants();
        if (this.actualHash != null) {
            this.verifyHash();
        }
        if (this.bufPos >= this.bufSafe && this.receivedHash == null) {
            this.fillBuf();
        }
        if (this.bufPos >= this.bufSafe) {
            return -1;
        }
        int n = Math.min(this.bufSafe - this.bufPos, len);
        this.arraycopy(this.buf, this.bufPos, b, off, n);
        this.bufPos += n;
        this.checkInvariants();
        return n;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.in.close();
    }

    private void fillBuf() throws IOException {
        if (this.bufPos < this.bufSafe) {
            throw this.badInvariants("fillBuf: bufPos >= bufSafe");
        }
        if (this.receivedHash != null) {
            throw this.badInvariants("fillBuf: receivedHash == null");
        }
        this.checkInvariants();
        this.bufPos = 0;
        this.bufLen -= this.bufSafe;
        this.arraycopy(this.buf, this.bufSafe, this.buf, 0, this.bufLen);
        this.bufLen += this.readAll(this.buf, this.bufLen, this.buf.length - this.bufLen);
        if (this.bufLen < this.buf.length) {
            if (this.bufLen < this.digLen) {
                CorruptStreamException e = new CorruptStreamException(String.format("Stream corrupt: stream short: algorithm=%s, hashLen=%d, streamLen=%d", this.dig.getAlgorithm(), this.dig.getDigestLength(), this.bufLen));
                throw this.corrupted(e);
            }
            this.bufLen -= this.digLen;
            this.receivedHash = new byte[this.digLen];
            this.arraycopy(this.buf, this.bufLen, this.receivedHash, 0, this.digLen);
            this.bufSafe = this.bufLen;
        } else {
            this.bufSafe = this.bufLen - this.digLen;
        }
        this.checkInvariants();
        if (this.bufSafe > 0) {
            this.dig.update(this.buf, 0, this.bufSafe);
        }
        if (this.bufLen < this.buf.length) {
            this.actualHash = this.dig.digest();
            this.verifyHash();
        }
        this.checkInvariants();
    }

    private void verifyHash() throws IOException {
        if (!Arrays.equals(this.receivedHash, this.actualHash)) {
            Formatter f = new Formatter();
            for (byte b : this.receivedHash) {
                f.format("%02x", b);
            }
            String received = f.toString();
            f = new Formatter();
            for (byte b : this.actualHash) {
                f.format("%02x", b);
            }
            String actual = f.toString();
            CorruptStreamException e = new CorruptStreamException(String.format("Stream corrupt: invalid hash: algorithm=%s, received=%s, actual=%s", this.dig.getAlgorithm(), received, actual));
            throw this.corrupted(e);
        }
    }

    private int readAll(byte[] b, int off, int len) throws IOException {
        try {
            int n;
            int total = 0;
            while (len > 0 && (n = this.in.read(b, off, len)) != -1) {
                off += n;
                len -= n;
                total += n;
            }
            return total;
        }
        catch (IOException e) {
            throw this.corrupted(e);
        }
    }

    private void arraycopy(Object src, int srcPos, Object dest, int destPos, int length) {
        try {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String msg = e.getMessage();
            msg = msg != null ? ": " + msg : "";
            msg = String.format("src=%s, srcPos=%d, dest=%s, destPos=%d, length=%d%s", src, srcPos, dest, destPos, length, msg);
            throw (ArrayIndexOutOfBoundsException)new ArrayIndexOutOfBoundsException(msg).initCause(e);
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    private void checkCorrupted() throws IOException {
        if (this.corruption != null) {
            throw this.corruption;
        }
    }

    private void checkInvariants() {
        if (this.bufPos < 0) {
            throw this.badInvariants("bufPos >= 0");
        }
        if (this.bufPos > this.bufSafe) {
            throw this.badInvariants("bufPos <= bufSafe");
        }
        if (this.bufSafe > this.bufLen) {
            throw this.badInvariants("bufSafe <= bufLen");
        }
        if (this.bufLen > this.buf.length) {
            throw this.badInvariants("bufLen <= buf.length");
        }
        if (this.buf.length - this.bufSafe < this.digLen) {
            throw this.badInvariants("buf.length - bufSafe >= digLen");
        }
    }

    private RuntimeException badInvariants(String invariant) {
        String msg = String.format("Broken invariant: %s: bufPos=%d, bufSafe=%d, bufLen=%d, buf.length=%d, digLen=%d", invariant, this.bufPos, this.bufSafe, this.bufLen, this.buf.length, this.digLen);
        throw new RuntimeException(msg);
    }

    private IOException corrupted(IOException cause) {
        if (this.corruption == null) {
            this.corruption = cause;
        }
        return cause;
    }
}

