/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.asm;

import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.lifecycle.LifecycleStoppedException;
import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.ItemTableScanner;
import java.io.InputStream;
import java.util.UUID;
import org.apache.log4j.Logger;

class BlobReplication
implements Runnable {
    private static final Logger log = Logger.getLogger(BlobReplication.class);
    private final BlobManager bm;
    private final UUID tableBlobId;

    BlobReplication(BlobManager bm, UUID tableBlobId) {
        this.bm = bm;
        this.tableBlobId = tableBlobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Replication started: blobId=" + this.tableBlobId));
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Replicating table blob " + this.tableBlobId));
            }
            this.bm.replicateBlobSync(this.tableBlobId);
            InputStream in = this.bm.openBlob(this.tableBlobId);
            if (in == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Blob not found: " + this.tableBlobId));
                }
                return;
            }
            try {
                AggregateItem item;
                ItemTableScanner scanner = new ItemTableScanner(in);
                int count = 0;
                while ((item = scanner.read()) != null) {
                    ++count;
                    String name = item.getDataFileName();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Table item: " + item.getPath() + "->" + name));
                    }
                    if (Aggregate.isSpecialDataFile((String)name)) {
                        if (!log.isTraceEnabled()) continue;
                        log.trace((Object)("Not replicating: not a blob ID: " + name));
                        continue;
                    }
                    UUID bid = UUID.fromString(name);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Replicating data blob " + bid));
                    }
                    this.bm.replicateBlobSync(bid);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Scanned " + count + " table items"));
                }
            }
            finally {
                in.close();
            }
        }
        catch (LifecycleStoppedException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Stopped", (Throwable)e);
            }
        }
        catch (Throwable t) {
            log.error((Object)("Replication failed: blobId=" + this.tableBlobId), t);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replication completed: blobId=" + this.tableBlobId));
            }
        }
    }
}

