/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.client.ops;

import com.ibm.uclab.csrepl.codestation.FileMetadata;
import java.text.SimpleDateFormat;

class VerifyResult {
    private final String path;
    private final VRType type;
    private final Object expected;
    private final Object actual;

    static VerifyResult ok(String path) {
        return new VerifyResult(path, VRType.OK, null, null);
    }

    static VerifyResult pathMissing(String path) {
        return new VerifyResult(path, VRType.PATH_MISSING, null, null);
    }

    static VerifyResult hashMissing(String path) {
        return new VerifyResult(path, VRType.HASH_MISSING, null, null);
    }

    static VerifyResult lengthChanged(String path, long expected, long actual) {
        return new VerifyResult(path, VRType.LENGTH_CHANGED, expected, actual);
    }

    static VerifyResult lastModifiedChanged(String path, long expected, long actual) {
        return new VerifyResult(path, VRType.LAST_MODIFIED_CHANGED, expected, actual);
    }

    static VerifyResult hashChanged(String path, String expected, String actual) {
        return new VerifyResult(path, VRType.HASH_CHANGED, expected, actual);
    }

    static VerifyResult typeChanged(String path, FileMetadata.Type expected, FileMetadata.Type actual) {
        return new VerifyResult(path, VRType.HASH_CHANGED, (Object)expected, (Object)actual);
    }

    private VerifyResult(String path, VRType type, Object expected, Object actual) {
        this.path = path;
        this.type = type;
        this.expected = expected;
        this.actual = actual;
    }

    boolean isOK() {
        return this.type == VRType.OK;
    }

    String getPath() {
        return this.path;
    }

    String getMessage() {
        switch (this.type) {
            case OK: {
                return "No change";
            }
            case PATH_MISSING: {
                return "Path missing";
            }
            case HASH_CHANGED: {
                return "Hash changed";
            }
            case HASH_MISSING: {
                return "No hash recorded";
            }
            case LAST_MODIFIED_CHANGED: {
                return "Last modified date changed";
            }
            case LENGTH_CHANGED: {
                return "Length changed";
            }
            case TYPE_CHANGED: {
                return "File type changed";
            }
        }
        return "Cannot verify: missing result case " + (Object)((Object)this.type);
    }

    String getDetail() {
        switch (this.type) {
            case OK: 
            case PATH_MISSING: 
            case HASH_MISSING: {
                return null;
            }
            case LAST_MODIFIED_CHANGED: {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
                return String.format("expected: %s; actual: %s", df.format(this.expected), df.format(this.actual));
            }
            case HASH_CHANGED: 
            case LENGTH_CHANGED: 
            case TYPE_CHANGED: {
                return String.format("expected: %s; actual: %s", this.expected, this.actual);
            }
        }
        return "Cannot verify: missing result case " + (Object)((Object)this.type);
    }

    private static enum VRType {
        OK,
        PATH_MISSING,
        HASH_MISSING,
        LENGTH_CHANGED,
        LAST_MODIFIED_CHANGED,
        HASH_CHANGED,
        TYPE_CHANGED;

    }
}

