/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.codestation.StreamFactoryArtifactSet;
import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateInputStream;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.AggregateReader;
import com.urbancode.codestation2.common.aggregate.streams.StreamFactory;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.zipwriter.InfoZipUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

class CodestationServiceImplAddToZip {
    private final AggregateFactory aggregateFactory;
    private final Copier copier;
    private final ArtifactSetManager asm;
    private final BlobManager bm;
    private final UUID id;
    private final ZipArchiveOutputStream zip;
    private final String pathPrefix;

    CodestationServiceImplAddToZip(ArtifactSetManager asm, BlobManager bm, UUID id, ZipArchiveOutputStream zip, String pathPrefix) {
        this(asm, bm, id, zip, pathPrefix, new Copier(), new AggregateFactory());
    }

    CodestationServiceImplAddToZip(ArtifactSetManager asm, BlobManager bm, UUID id, ZipArchiveOutputStream zip, String pathPrefix, Copier copier, AggregateFactory aggregateFactory) {
        if (pathPrefix != null && !Aggregate.isPathValid((String)(pathPrefix = Aggregate.sanitizePath((String)pathPrefix)))) {
            throw new IllegalArgumentException("invalid path");
        }
        this.aggregateFactory = aggregateFactory;
        this.aggregateFactory.getClass();
        this.copier = copier;
        this.copier.getClass();
        this.asm = asm;
        this.bm = bm;
        this.id = id;
        this.zip = zip;
        this.pathPrefix = pathPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void run() throws IOException {
        Aggregate aggr = this.aggregateFactory.create(this.asm, this.bm, this.id);
        AggregateReader reader = aggr.openReader(null);
        try {
            AggregateInputStream in;
            ZipArchiveEntry entry;
            String path;
            int mode;
            InfoZipUtil.Type type;
            for (AggregateItem item : reader.getTable()) {
                if (item.getType() != 2 || item.isMetaOnly()) continue;
                type = InfoZipUtil.Type.DIRECTORY;
                mode = 493;
                if (item.getUnixMode() != null) {
                    mode = item.getUnixMode();
                }
                path = item.getPath();
                if (this.pathPrefix != null) {
                    path = this.pathPrefix + "/" + path;
                }
                entry = new ZipArchiveEntry(path + "/");
                entry.setUnixMode(InfoZipUtil.createUnixMode((InfoZipUtil.Type)type, (int)mode));
                entry.addExtraField(InfoZipUtil.createTimestampField((long)item.getLastModified()));
                entry.setTime(item.getLastModified());
                this.zip.putArchiveEntry((ArchiveEntry)entry);
                this.zip.closeArchiveEntry();
            }
            block13: while ((in = reader.read()) != null) {
                try {
                    AggregateItem item;
                    item = in.getItem();
                    switch (item.getType()) {
                        case 1: {
                            if (item.isMetaOnly()) continue block13;
                            type = InfoZipUtil.Type.FILE;
                            break;
                        }
                        case 3: {
                            type = InfoZipUtil.Type.SYMLINK;
                            break;
                        }
                        default: {
                            continue block13;
                        }
                    }
                    mode = 420;
                    if (item.getUnixMode() != null) {
                        mode = item.getUnixMode();
                    }
                    path = item.getPath();
                    if (this.pathPrefix != null) {
                        path = this.pathPrefix + "/" + path;
                    }
                    entry = new ZipArchiveEntry(path);
                    entry.setUnixMode(InfoZipUtil.createUnixMode((InfoZipUtil.Type)type, (int)mode));
                    entry.addExtraField(InfoZipUtil.createTimestampField((long)item.getLastModified()));
                    entry.setTime(item.getLastModified());
                    this.zip.putArchiveEntry((ArchiveEntry)entry);
                    this.copier.copy((InputStream)in, (OutputStream)this.zip);
                    this.zip.closeArchiveEntry();
                }
                finally {
                    in.close();
                }
            }
            return;
        }
        finally {
            reader.close();
        }
    }

    static class AggregateFactory {
        AggregateFactory() {
        }

        Aggregate create(ArtifactSetManager asm, BlobManager bm, UUID id) {
            return new Aggregate(null, null, (StreamFactory)new StreamFactoryArtifactSet(asm, bm, id));
        }
    }

    static class Copier {
        Copier() {
        }

        void copy(InputStream in, OutputStream out) throws IOException {
            IO.copy((InputStream)in, (OutputStream)out);
        }
    }
}

