/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.Download;
import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.commons.util.processes.Processes;
import com.urbancode.plugins.ucd.vfs.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;

public class DownloadForZosCommand {
    static final String PACKAGE_ZIP = "package.zip";
    static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";

    public static void main(String[] args) throws Exception {
        File zipFile;
        File workDir;
        AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
        Properties props = apTool.getStepProperties();
        String repositoryType = StringUtils.trimToNull((String)props.getProperty("repositoryType"));
        String versionName = StringUtils.trimToNull((String)props.getProperty("versionName"));
        UUID versionId = UUID.fromString(StringUtils.trimToNull((String)props.getProperty("versionId")));
        String resourceId = StringUtils.trimToNull((String)props.getProperty("resourceId"));
        String directoryOffset = StringUtils.trimToNull((String)props.getProperty("directoryOffset"));
        String serverUrl = Util.parseServerUrl(props.getProperty("serverUrl"));
        Charset charset = Util.getCharset(props);
        if (!"CODESTATION".equalsIgnoreCase(repositoryType)) {
            if ("HFS".equalsIgnoreCase(repositoryType)) {
                System.out.println("Version " + versionName + "(" + versionId + ") is stored in zOS HFS. Use Copy Artifacts or FTP Artifacts plug-in steps to retrieve the version artifacts.");
            } else {
                System.out.println("Version " + versionName + "(" + versionId + ") is not stored in CodeStation.");
            }
            System.out.println("Download failed.");
            System.exit(1);
        }
        File baseDirectory = workDir = new File("." + File.separator + resourceId + File.separator + versionName).getCanonicalFile();
        if (directoryOffset != null) {
            baseDirectory = new File(workDir, directoryOffset).getCanonicalFile();
        }
        if (baseDirectory.exists() && baseDirectory.isDirectory()) {
            System.out.println("Deleting base directory - " + baseDirectory);
            Util.deleteDir(baseDirectory);
        }
        baseDirectory.mkdirs();
        if (baseDirectory.isFile()) {
            throw new IllegalArgumentException("Base directory " + baseDirectory + " is a file");
        }
        Util.configureLogging();
        CodestationClient csClient = Util.getCodestationClient(serverUrl, false, apTool.getAuthTokenUsername(), apTool.getAuthToken());
        Download op = new Download(csClient, baseDirectory, versionId);
        op.setIncludes(Arrays.asList(PACKAGE_ZIP, PACKAGE_MANIFEST_XML));
        op.setOutputCharset(charset);
        System.out.println("Artifact source: " + csClient.getUrl());
        System.out.println("Working directory: " + baseDirectory);
        System.out.println("Offset " + directoryOffset);
        System.out.println();
        op.run();
        File pkgManifestFile = new File(baseDirectory, PACKAGE_MANIFEST_XML);
        if (!pkgManifestFile.exists()) {
            System.out.println("Error: packageManifest.xml not found in CodeStation");
            System.exit(1);
        }
        if (DownloadForZosCommand.isSecondVersion(pkgManifestFile) && (zipFile = new File(baseDirectory, PACKAGE_ZIP)).exists()) {
            Processes processes = new Processes();
            String[] cmdArgs = new String[]{"pax", "-r", "-vf", zipFile.getPath()};
            Process process = new ProcessBuilder(cmdArgs).directory(baseDirectory).start();
            process.getOutputStream().close();
            Future<String> sout = processes.getOutputStringFuture(process);
            Future<String> serr = processes.getErrorStringFuture(process);
            process.waitFor();
            if (process.exitValue() > 0 || serr.get().contains(":") || sout.get().contains(":")) {
                System.out.println("Error while extracting files from package.zip");
                System.exit(1);
            }
            try {
                zipFile.renameTo(new File(baseDirectory, "processed_package.zip"));
            }
            catch (Exception e) {
                System.out.println("Error while renaming the package.zip file");
                e.printStackTrace();
                System.exit(1);
            }
            System.out.println("Deployment package extracted successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSecondVersion(File verFile) throws IOException {
        block8: {
            String input = "<manifest type=\"MANIFEST_LIST\" version=\"v2_0\"";
            BufferedReader br = new BufferedReader(new FileReader(verFile));
            block4: while (true) {
                String splitStr = br.readLine();
                if (splitStr != null) {
                    String[] words;
                    String[] stringArray = words = splitStr.split(">");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block4;
                        String word = stringArray[n2];
                        if (word.contains(input)) {
                            boolean bl = true;
                            return bl;
                        }
                        ++n2;
                    }
                }
                break block8;
                break;
            }
            finally {
                br.close();
            }
        }
        return false;
    }
}

