/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.Download;
import com.ibm.uclab.csrepl.client.ops.DownloadSync;
import com.ibm.uclab.csrepl.client.ops.Sync;
import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.plugins.ucd.vfs.ApiCallHelper;
import com.urbancode.plugins.ucd.vfs.Util;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadByLabelCommand {
    private static AirPluginTool apTool;
    private static ApiCallHelper apiCallHelper;
    private static String resId;
    private static String compId;
    private static String envId;
    private static String label;
    private static String serverUrl;

    public static void main(String[] args) throws Exception {
        Download op;
        File workDir;
        apTool = new AirPluginTool(args[0], args[1]);
        apiCallHelper = new ApiCallHelper(apTool.getAuthTokenUsername(), apTool.getAuthToken());
        Properties props = apTool.getStepProperties();
        resId = props.getProperty("resId");
        compId = props.getProperty("compId");
        envId = props.getProperty("envId");
        label = props.getProperty("label");
        serverUrl = Util.parseServerUrl(props.getProperty("serverUrl"));
        UUID versionId = Util.parseUUID(props.getProperty("versionId"));
        String artifactSetBaseDir = props.getProperty("artifactSetBaseDir");
        String directoryOffset = props.getProperty("directoryOffset");
        String fileIncludePatterns = props.getProperty("fileIncludePatterns");
        String fileExcludePatterns = props.getProperty("fileExcludePatterns");
        String syncMode = props.getProperty("syncMode");
        boolean fullVerification = Util.parseBoolean(props.getProperty("fullVerification"));
        boolean handleIncrementalVersions = Util.parseBoolean(props.getProperty("handleIncrementalVersions"));
        boolean versionIsIncremental = "incremental".equals(props.getProperty("versionType"));
        boolean setFileExecuteBits = Util.parseBoolean(props.getProperty("setFileExecuteBits"));
        boolean verifyFileIntegrity = Util.parseBoolean(props.getProperty("verifyFileIntegrity"));
        Charset charset = Util.getCharset(props);
        File baseDirectory = workDir = new File(".").getCanonicalFile();
        if (directoryOffset != null) {
            baseDirectory = new File(workDir, directoryOffset).getCanonicalFile();
        }
        List<String> includes = Util.parseLines(fileIncludePatterns);
        List<String> excludes = Util.parseLines(fileExcludePatterns);
        boolean useSync = !syncMode.equals("false");
        boolean fullClean = syncMode.equals("FULL");
        baseDirectory.mkdirs();
        if (baseDirectory.isFile()) {
            throw new IllegalArgumentException("Base directory ${baseDirectory} is a file!");
        }
        Util.configureLogging();
        if (versionId == null) {
            System.out.println("Cannot parse version ID - attempting to resolve from component ID and label...");
            System.out.printf("  Component ID: %s%n", compId);
            System.out.printf("  Label: %s%n", label);
            UUID resolvedVersionId = DownloadByLabelCommand.resolveVersionId();
            if (resolvedVersionId != null) {
                System.out.printf("Resolved version ID %s%n", resolvedVersionId);
                versionId = resolvedVersionId;
            } else {
                System.out.println("Resolution failed - terminating step.");
                System.exit(1);
            }
        }
        CodestationClient csClient = Util.getCodestationClient(serverUrl, false, apTool.getAuthTokenUsername(), apTool.getAuthToken());
        if (useSync) {
            if (handleIncrementalVersions) {
                List<UUID> previousVersionIds = DownloadByLabelCommand.getPreviousVersionIds();
                if (versionIsIncremental) {
                    System.out.println("Deploying incremental version");
                    ArrayList<UUID> allVersionIds = new ArrayList<UUID>(previousVersionIds.size() + 1);
                    allVersionIds.addAll(previousVersionIds);
                    allVersionIds.add(versionId);
                    Sync op2 = new Sync(csClient, baseDirectory, allVersionIds);
                    op2.setSkipClean(true);
                    op = op2;
                } else {
                    DownloadSync op2 = new DownloadSync(csClient, baseDirectory, versionId, previousVersionIds);
                    op2.setFullClean(fullClean);
                    op = op2;
                }
            } else {
                List<UUID> previousVersionIds = Collections.singletonList(DownloadByLabelCommand.getPreviousVersionId());
                DownloadSync op2 = new DownloadSync(csClient, baseDirectory, versionId, previousVersionIds);
                op2.setFullClean(fullClean);
                op = op2;
            }
        } else {
            op = new Download(csClient, baseDirectory, versionId);
        }
        op.setMaxDownloadAttempts(apiCallHelper.getMaxTries());
        op.setIncludes(includes);
        op.setExcludes(excludes);
        op.setOutputCharset(charset);
        op.setSetExecuteBits(setFileExecuteBits);
        op.setSourcePathOffset(artifactSetBaseDir);
        op.setVerifyFiles(verifyFileIntegrity);
        op.setSlowVerification(fullVerification);
        System.out.printf("Artifact source: %s%n", csClient.getUrl());
        System.out.printf("Working directory: %s%n", baseDirectory.getPath());
        System.out.printf("Including %s%n", fileIncludePatterns);
        System.out.printf("Excluding %s%n", fileExcludePatterns);
        System.out.printf("Offset %s%n", directoryOffset);
        System.out.printf("Artifact base directory %s%n", artifactSetBaseDir);
        System.out.printf("Set file bits are %s%n", setFileExecuteBits);
        System.out.println();
        op.run();
    }

    private static UUID getPreviousVersionId() throws Exception {
        String reqUrl = String.format("%s/rest/inventory/versionByResourceAndComponent/%s/%s", serverUrl, resId, compId);
        ApiCallHelper.HttpResult httpResult = apiCallHelper.callApi((HttpUriRequest)new HttpGet(reqUrl), "getting previous version ID for resource");
        switch (httpResult.getCode()) {
            case 200: {
                JSONObject version;
                JSONObject res = new JSONObject(httpResult.getContent());
                if (!res.isNull("version") && !(version = res.getJSONObject("version")).isNull("id")) {
                    return UUID.fromString(version.getString("id"));
                }
                return null;
            }
            case 404: {
                System.out.println("Server returned 404 for getting the previous version ID");
                return null;
            }
        }
        System.out.println("Could not get previous version ID. Method returned code " + httpResult.getCode());
        return null;
    }

    private static List<UUID> getPreviousVersionIds() throws Exception {
        List<UUID> result = DownloadByLabelCommand.getPreviousVersionIdsFast();
        if (result == null) {
            System.out.println("Using slower fallback that is compatible with older servers to get previous version IDs.");
            result = DownloadByLabelCommand.getPreviousVersionIdsSlower();
        }
        if (result == null) {
            System.out.println("Using slowest fallback that is compatible with most servers to get previous version IDs.");
            result = DownloadByLabelCommand.getPreviousVersionIdsSlowest();
        }
        return result;
    }

    private static List<UUID> getPreviousVersionIdsSlowest() throws Exception {
        String reqUrl = String.format("%s/rest/inventory/environmentInventoryByResource/%s", serverUrl, envId);
        ApiCallHelper.HttpResult httpResult = apiCallHelper.callApi((HttpUriRequest)new HttpGet(reqUrl), "getting previous version IDs for resource");
        switch (httpResult.getCode()) {
            case 200: {
                JSONArray resources = new JSONArray(httpResult.getContent());
                ArrayList<DateOrderedVersionId> ids = new ArrayList<DateOrderedVersionId>();
                for (int i = 0; i < resources.length(); ++i) {
                    Object childrenObj;
                    JSONObject resource = resources.getJSONObject(i);
                    if (!resId.equalsIgnoreCase(resource.getString("id")) || !((childrenObj = resource.opt("children")) instanceof JSONArray)) continue;
                    JSONArray children = (JSONArray)childrenObj;
                    for (int j = 0; j < children.length(); ++j) {
                        JSONObject entry = children.getJSONObject(j);
                        if (!compId.equalsIgnoreCase(entry.getJSONObject("component").getString("id"))) continue;
                        ids.add(new DateOrderedVersionId(UUID.fromString(entry.getJSONObject("version").getString("id")), entry.getLong("date")));
                    }
                }
                Collections.sort(ids);
                ArrayList<UUID> result = new ArrayList<UUID>(ids.size());
                for (DateOrderedVersionId id : ids) {
                    result.add(id.versionId);
                }
                return result;
            }
            case 404: {
                System.out.println("Server returned 404 for getting the previous version IDs.");
                return null;
            }
        }
        System.out.println("Could not get previous version IDs. Method returned code " + httpResult.getCode());
        return null;
    }

    private static List<UUID> getPreviousVersionIdsSlower() throws Exception {
        URI uri = new URIBuilder(serverUrl + "/rest/inventory/resourceInventory/table").addParameter("rowsPerPage", "1000000").addParameter("pageNumber", "1").addParameter("filterFields", "resourceId").addParameter("filterFields", "componentId").addParameter("filterFields", "ghostedDate").addParameter("filterValue_resourceId", resId).addParameter("filterValue_componentId", compId).addParameter("filterValue_ghostedDate", "0").addParameter("filterType_resourceId", "eq").addParameter("filterType_componentId", "eq").addParameter("filterType_ghostedDate", "eq").addParameter("filterClass_resourceId", "String").addParameter("filterClass_componentId", "String").addParameter("filterClass_ghostedDate", "Long").addParameter("orderField", "dateCreated").addParameter("sortType", "asc").build();
        ApiCallHelper.HttpResult httpResult = apiCallHelper.callApi((HttpUriRequest)new HttpGet(uri), "getting previous version IDs for resource");
        switch (httpResult.getCode()) {
            case 200: {
                ArrayList<UUID> versionIds = new ArrayList<UUID>();
                JSONObject response = new JSONObject(httpResult.getContent());
                JSONArray records = response.getJSONArray("records");
                for (int i = 0; i < records.length(); ++i) {
                    JSONObject inventoryEntry = records.getJSONObject(i);
                    JSONObject version = inventoryEntry.getJSONObject("version");
                    versionIds.add(UUID.fromString(version.getString("id")));
                }
                return versionIds;
            }
            case 404: {
                System.out.println("Server returned 404 for getting the previous versions.");
                return null;
            }
            case 403: {
                System.out.println("Server returned 403 for getting the previous version IDs.");
                System.out.println("The auth token restriction logic may be limiting multivalued query parameters.");
                return null;
            }
        }
        System.out.println("Could not get previous versions. Method returned code " + httpResult.getCode());
        return null;
    }

    private static List<UUID> getPreviousVersionIdsFast() throws Exception {
        URI uri = new URIBuilder(serverUrl + "/cli/inventory/getResourceInventoryEntriesForComponent").addParameter("resource", resId).addParameter("component", compId).build();
        ApiCallHelper.HttpResult httpResult = apiCallHelper.callApi((HttpUriRequest)new HttpGet(uri), "getting previous version IDs for resource");
        switch (httpResult.getCode()) {
            case 200: {
                ArrayList<UUID> versionIds = new ArrayList<UUID>();
                JSONArray response = new JSONArray(httpResult.getContent());
                for (int i = 0; i < response.length(); ++i) {
                    JSONObject entry = response.getJSONObject(i);
                    versionIds.add(UUID.fromString(entry.getString("versionId")));
                }
                return versionIds;
            }
            case 404: {
                System.out.println("Server returned 404 for getting the previous versions.");
                System.out.println("The server may be too old to for this API.");
                return null;
            }
        }
        System.out.println("Could not get previous versions. Method returned code " + httpResult.getCode());
        return null;
    }

    private static UUID resolveVersionId() throws Exception {
        URI uri = new URIBuilder(serverUrl + "/cli/version/getVersionId").addParameter("component", compId).addParameter("version", label).build();
        ApiCallHelper.HttpResult httpResult = apiCallHelper.callApi((HttpUriRequest)new HttpGet(uri), "resolving version ID");
        switch (httpResult.getCode()) {
            case 200: {
                return UUID.fromString(httpResult.getContent().trim());
            }
        }
        System.out.println("Could not resolve version ID. Method returned code " + httpResult.getCode());
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateOrderedVersionId
    implements Comparable<DateOrderedVersionId> {
        final UUID versionId;
        final long date;

        DateOrderedVersionId(UUID versionId, long date) {
            this.versionId = versionId;
            this.date = date;
        }

        @Override
        public int compareTo(DateOrderedVersionId rhs) {
            if (this.date < rhs.date) {
                return -1;
            }
            if (this.date == rhs.date) {
                return 0;
            }
            return 1;
        }
    }
}

