/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.codestation.Filter;
import com.ibm.uclab.csrepl.rest.KeysParam;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

class MetaFilter {
    private final Filter fileFilter;
    private final Set<String> keys;

    static MetaFilter fromJSON(String json) throws JSONException {
        Filter fileFilter = Filter.fromJSON(json);
        JSONObject jo = new JSONObject(json);
        HashSet<String> keys = null;
        if (jo.has("keys")) {
            keys = new HashSet<String>();
            JSONArray ks = jo.getJSONArray("keys");
            for (int i = 0; i < ks.length(); ++i) {
                String k;
                if (ks.isNull(i) || (k = ks.getString(i).trim()).length() <= 0) continue;
                keys.add(k);
            }
        }
        return new MetaFilter(fileFilter, keys);
    }

    static MetaFilter fromKeysParam(KeysParam param) {
        if (param == null) {
            return MetaFilter.getDefaultFilter();
        }
        return new MetaFilter(null, param.getKeys());
    }

    static MetaFilter fromFilterAndKeys(Filter filter, Set<String> keys) {
        if (filter == null && keys == null) {
            return MetaFilter.getDefaultFilter();
        }
        if (keys != null) {
            keys = Collections.unmodifiableSet(new HashSet<String>(keys));
        }
        return new MetaFilter(filter, keys);
    }

    static MetaFilter getDefaultFilter() {
        return new MetaFilter(null, null);
    }

    private MetaFilter(Filter fileFilter, Set<String> keys) {
        this.fileFilter = fileFilter;
        this.keys = keys;
    }

    public Filter getFileFilter() {
        return this.fileFilter;
    }

    public Set<String> getKeys() {
        if (this.keys == null) {
            return FileMetadata.getAllJSONKeys();
        }
        return this.keys;
    }

    public JSONObject toJSON() {
        try {
            JSONObject jo = this.fileFilter != null ? this.fileFilter.toJSON() : new JSONObject();
            if (this.keys != null) {
                jo.put("keys", (Object)new JSONArray(this.keys));
            }
            return jo;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

