/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import com.urbancode.plugins.ucd.vfs.Util;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

class ApiCallHelper {
    private static final int MAX_TRIES = 5;
    private final String user;
    private final String password;
    private final String proxyHost;
    private final int proxyPort;
    private CloseableHttpClient apiHttpClient;

    ApiCallHelper(String user, String password) {
        this.user = user;
        this.user.getClass();
        this.password = password;
        this.password.getClass();
        this.proxyHost = Util.getenv("PROXY_HOST");
        this.proxyPort = Util.parseInt(Util.getenv("PROXY_PORT"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResult callApi(HttpUriRequest req, String callDescription) throws Exception {
        CloseableHttpClient client = this.getApiHttpClient();
        int tries = 0;
        while (true) {
            HttpResult httpResult;
            CloseableHttpResponse res = client.execute(req);
            try {
                int code = res.getStatusLine().getStatusCode();
                String content = EntityUtils.toString((HttpEntity)res.getEntity());
                httpResult = new HttpResult(code, content);
            }
            catch (Throwable throwable) {
                try {
                    res.close();
                    throw throwable;
                }
                catch (Exception e) {
                    if (++tries >= 5) {
                        throw e;
                    }
                    System.out.println("Error " + callDescription + " : " + e.getMessage());
                    continue;
                }
            }
            res.close();
            return httpResult;
            break;
        }
    }

    public int getMaxTries() {
        return 5;
    }

    private CloseableHttpClient getApiHttpClient() {
        if (this.apiHttpClient == null) {
            HttpClientBuilder2 builder = new HttpClientBuilder2();
            if (this.proxyHost != null) {
                builder.setProxyHost(this.proxyHost);
                builder.setProxyPort(this.proxyPort);
            }
            builder.setUsername(this.user);
            builder.setPassword(this.password);
            builder.setPreemptiveAuthentication(true);
            boolean verifyCerts = Util.parseBoolean(Util.getenv("UC_TLS_VERIFY_CERTS"));
            builder.setTrustAllCerts(!verifyCerts);
            this.apiHttpClient = builder.buildClient();
        }
        return this.apiHttpClient;
    }

    public static class HttpResult {
        private final int code;
        private final String content;

        HttpResult(int code, String content) {
            this.code = code;
            this.content = content;
        }

        public int getCode() {
            return this.code;
        }

        public String getContent() {
            return this.content;
        }
    }
}

