/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.blobstore;

import com.ibm.uclab.csrepl.blobstore.BlobReplicatorImpl;
import com.ibm.uclab.csrepl.moveable.MoveableFileInputStream;
import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;

class BlobReplicatorStream
extends SeekableInputStream {
    private final BlobReplicatorImpl saver;
    private final MoveableFileInputStream in;
    private final long length;
    private byte[] one;
    private final Object updateLock;
    private long writePosition;
    private long readPosition;
    private boolean eof;
    private IOException error;
    private boolean failIfWouldBlockForUpdate;

    BlobReplicatorStream(BlobReplicatorImpl saver, MoveableFileInputStream in, long length) {
        if (length < -1L) {
            throw new IllegalArgumentException("invalid length: " + length);
        }
        this.saver = saver;
        this.updateLock = new Object();
        this.in = in;
        this.length = length;
    }

    public synchronized int read() throws IOException {
        int n;
        if (this.one == null) {
            this.one = new byte[1];
        }
        if ((n = this.read(this.one, 0, this.one.length)) == -1) {
            return n;
        }
        return this.one[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int n = 0;
        while (n == 0 && len != 0) {
            boolean localEof;
            long localWritePosition;
            Object object = this.updateLock;
            synchronized (object) {
                while (true) {
                    if (this.error != null) {
                        throw this.error;
                    }
                    localWritePosition = this.writePosition;
                    localEof = this.eof;
                    if (this.readPosition < localWritePosition || localEof) break;
                    try {
                        if (this.failIfWouldBlockForUpdate) {
                            throw new WouldBlockException();
                        }
                        this.updateLock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
            }
            if (this.readPosition < localWritePosition) {
                int cnt = (int)Math.min((long)len, localWritePosition - this.readPosition);
                n = this.in.read(b, off, cnt);
                if (n < 0) {
                    n = 0;
                }
                this.readPosition += (long)n;
                continue;
            }
            if (!localEof) continue;
            n = -1;
        }
        return n;
    }

    public void close() throws IOException {
        if (this.saver != null) {
            this.saver.unregisterStream(this);
        }
        this.in.close();
    }

    public synchronized void seek(long position) throws IOException {
        this.in.seek(position);
        this.readPosition = position;
    }

    public synchronized long position() throws IOException {
        return this.in.position();
    }

    public long length() throws IOException {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(long total) {
        Object object = this.updateLock;
        synchronized (object) {
            if (total < this.writePosition) {
                throw new AssertionError((Object)String.format("update total went backwards: total=%d, writePosition=%d", total, this.writePosition));
            }
            this.writePosition = total;
            this.updateLock.notifyAll();
        }
    }

    void preMove() throws IOException {
        this.in.preMove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postMove(long total, File newFile) {
        this.in.postMove(newFile);
        Object object = this.updateLock;
        synchronized (object) {
            this.eof = true;
            this.update(total);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fail(IOException error) {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.error == null) {
                this.error = error;
            }
            this.updateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFailIfWouldBlockForUpdate(boolean failIfWouldBlockForUpdate) {
        Object object = this.updateLock;
        synchronized (object) {
            this.failIfWouldBlockForUpdate = failIfWouldBlockForUpdate;
        }
    }

    static class WouldBlockException
    extends IOException {
        private static final long serialVersionUID = 1L;

        WouldBlockException() {
        }
    }
}

