/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.streams;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.apache.log4j.Logger;

public class HashInjectingInputStream
extends InputStream {
    private final InputStream in;
    private final MessageDigest dig;
    private byte[] hash;
    private int hashPos;
    private volatile boolean aborted;
    private static final Logger log = Logger.getLogger(HashInjectingInputStream.class);

    public HashInjectingInputStream(InputStream in, MessageDigest dig) {
        this.in = in;
        this.dig = dig;
    }

    @Override
    public synchronized int read() throws IOException {
        try {
            if (this.hash != null) {
                return this.readHash();
            }
            int b = this.read0();
            if (b < 0) {
                this.hash = this.dig.digest();
                return this.readHash();
            }
            this.dig.update((byte)b);
            return b;
        }
        catch (IOException e) {
            log.error((Object)"An Error Reading Has Occurred", (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        try {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || b.length - off < len) {
                throw new IndexOutOfBoundsException();
            }
            if (this.hash != null) {
                return this.readHash(b, off, len);
            }
            int n = this.read0(b, off, len);
            if (n < 0) {
                this.hash = this.dig.digest();
                return this.readHash(b, off, len);
            }
            this.dig.update(b, off, n);
            return n;
        }
        catch (IOException e) {
            log.error((Object)"An Error Reading Has Occurred", (Throwable)e);
            throw e;
        }
    }

    public void abort() throws IOException {
        try {
            log.error((Object)"ABORTING");
            this.aborted = true;
            this.in.close();
        }
        catch (IOException e) {
            log.error((Object)"An Error Aborting Has Occurred", (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.hash = null;
            this.in.close();
        }
        catch (IOException e) {
            log.error((Object)"An Error Closing Has Occurred", (Throwable)e);
            throw e;
        }
    }

    private int readHash() {
        if (this.hashPos >= this.hash.length) {
            return -1;
        }
        return this.hash[this.hashPos++] & 0xFF;
    }

    private int readHash(byte[] b, int off, int len) {
        if (this.aborted) {
            this.hash = null;
            return -1;
        }
        if (this.hashPos >= this.hash.length) {
            return -1;
        }
        int n = Math.min(this.hash.length - this.hashPos, len);
        System.arraycopy(this.hash, this.hashPos, b, off, n);
        this.hashPos += n;
        return n;
    }

    private int read0() throws IOException {
        try {
            return this.in.read();
        }
        catch (IOException e) {
            log.error((Object)"An IO Error Reading Has Occurred", (Throwable)e);
            if (this.aborted) {
                return -1;
            }
            throw e;
        }
    }

    private int read0(byte[] b, int off, int len) throws IOException {
        try {
            return this.in.read(b, off, len);
        }
        catch (IOException e) {
            log.error((Object)"An IO Error Reading Has Occurred", (Throwable)e);
            if (this.aborted) {
                return -1;
            }
            throw e;
        }
    }
}

