/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.http.range;

import com.ibm.uclab.csrepl.http.range.ByteRange;
import com.ibm.uclab.csrepl.http.range.RangeFormatException;
import com.urbancode.commons.util.Check;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ByteRangeParser {
    static final boolean[] validChars = new boolean[58];
    private final String rangeHeader;
    private List<ByteRange> ranges;

    public ByteRangeParser(String rangeHeader) {
        Check.nonNull((Object)rangeHeader);
        this.rangeHeader = rangeHeader;
    }

    public synchronized List<ByteRange> getRanges() throws RangeFormatException {
        if (this.ranges == null) {
            this.parse();
        } else {
            this.ranges = Collections.emptyList();
        }
        return this.ranges;
    }

    public String toString() {
        return "ByteRangeParser {" + this.rangeHeader + "}";
    }

    private void parse() throws RangeFormatException {
        int eq = this.rangeHeader.indexOf(61);
        if (eq == -1) {
            throw this.createError();
        }
        String unit = this.rangeHeader.substring(0, eq);
        if (!"bytes".equals(unit)) {
            throw this.createError();
        }
        String ranges = this.rangeHeader.substring(eq + 1);
        for (int i = 0; i < ranges.length(); ++i) {
            char c = ranges.charAt(i);
            if (c < validChars.length && validChars[c]) continue;
            throw this.createError();
        }
        ArrayList<ByteRange> rangeList = new ArrayList<ByteRange>();
        for (String range : ranges.split(",")) {
            ByteRange r = this.parseRange(range);
            if (r == null) continue;
            rangeList.add(r);
        }
        if (rangeList.isEmpty()) {
            throw this.createError();
        }
        if (rangeList.size() == 1) {
            this.ranges = Collections.singletonList(rangeList.get(0));
        } else {
            rangeList.trimToSize();
            this.ranges = Collections.unmodifiableList(rangeList);
        }
    }

    private ByteRange parseRange(String rangeFragment) throws RangeFormatException {
        if ((rangeFragment = rangeFragment.trim()).length() == 0) {
            return null;
        }
        int sep = rangeFragment.indexOf(45);
        if (sep == -1) {
            throw this.createError();
        }
        String left = rangeFragment.substring(0, sep);
        String right = rangeFragment.substring(sep + 1);
        if (!left.equals(left.trim())) {
            throw this.createError();
        }
        if (!right.equals(right.trim())) {
            throw this.createError();
        }
        if (left.length() == 0 && right.length() == 0) {
            throw this.createError();
        }
        long leftNumeric = -1L;
        if (left.length() != 0) {
            leftNumeric = this.parseLong(left);
        }
        long rightNumeric = -1L;
        if (right.length() != 0) {
            rightNumeric = this.parseLong(right);
        }
        if (leftNumeric != -1L && rightNumeric != -1L && rightNumeric < leftNumeric) {
            throw this.createError();
        }
        if (leftNumeric == Long.MAX_VALUE || rightNumeric == Long.MAX_VALUE) {
            throw this.createError();
        }
        if (leftNumeric != -1L && rightNumeric != -1L) {
            return ByteRange.fromTo(leftNumeric, rightNumeric);
        }
        if (leftNumeric != -1L) {
            return ByteRange.fromToEnd(leftNumeric);
        }
        return ByteRange.last(rightNumeric);
    }

    private long parseLong(String s) throws RangeFormatException {
        try {
            if (s.indexOf(45) != -1) {
                throw this.createError();
            }
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw this.createError();
        }
    }

    private RangeFormatException createError() {
        return new RangeFormatException("bad byte range: " + this.rangeHeader);
    }

    static {
        ByteRangeParser.validChars[32] = true;
        ByteRangeParser.validChars[45] = true;
        ByteRangeParser.validChars[9] = true;
        ByteRangeParser.validChars[44] = true;
        for (int i = 0; i < 10; ++i) {
            ByteRangeParser.validChars[48 + i] = true;
        }
    }
}

