/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.commons.util.FileFilterToRegex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class PathFilter {
    private List<String> includeLiterals;
    private List<String> excludeLiterals;
    private List<Pattern> includes;
    private List<Pattern> excludes;
    private boolean stripLeadingSlashInAccept;

    public static PathFilter compile(String[] includes, String[] excludes, boolean stripLeadingSlashInAccept) {
        PathFilter result = new PathFilter(stripLeadingSlashInAccept);
        boolean includesAll = false;
        if (includes != null) {
            for (String inc : includes) {
                if (!inc.equals("**/*")) continue;
                includesAll = true;
                break;
            }
        }
        if (includes != null && (includes.length == 0 || includesAll)) {
            includes = null;
        }
        if (excludes != null && excludes.length == 0) {
            excludes = null;
        }
        if (includes != null) {
            ArrayList<String> includeLiterals = new ArrayList<String>();
            ArrayList<Pattern> includePatterns = new ArrayList<Pattern>();
            String[] arr$ = includes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String inc = arr$[i$];
                if (!PathFilter.containsWildCards(inc)) {
                    includeLiterals.add(PathFilter.normalizePath(inc, stripLeadingSlashInAccept));
                    continue;
                }
                includePatterns.add(FileFilterToRegex.convert((String)inc));
            }
            if (!includeLiterals.isEmpty()) {
                Collections.sort(includeLiterals);
                includeLiterals.trimToSize();
                result.includeLiterals = includeLiterals;
            }
            if (!includePatterns.isEmpty()) {
                includePatterns.trimToSize();
                result.includes = includePatterns;
            }
        }
        if (excludes != null) {
            ArrayList<String> excludeLiterals = new ArrayList<String>();
            ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>();
            for (String exc : excludes) {
                if (!PathFilter.containsWildCards(exc)) {
                    excludeLiterals.add(PathFilter.normalizePath(exc, stripLeadingSlashInAccept));
                    continue;
                }
                excludePatterns.add(FileFilterToRegex.convert((String)exc));
            }
            if (!excludeLiterals.isEmpty()) {
                Collections.sort(excludeLiterals);
                excludeLiterals.trimToSize();
                result.excludeLiterals = excludeLiterals;
            }
            if (!excludePatterns.isEmpty()) {
                excludePatterns.trimToSize();
                result.excludes = excludePatterns;
            }
        }
        return result;
    }

    static boolean containsWildCards(String expression) {
        return expression.contains("*") || expression.contains("?");
    }

    private static String normalizePath(String path, boolean stripLeadingSlashInAccept) {
        if (path != null) {
            path = path.replace('\\', '/');
            if ((path = path.replaceAll("/+", "/")).endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (stripLeadingSlashInAccept && path.startsWith("/")) {
                path = path.substring(1);
            }
        }
        return path;
    }

    private static <T> List<T> asList(T[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return Arrays.asList(array);
    }

    protected PathFilter(boolean stripLeadingSlashInAccept) {
        this.stripLeadingSlashInAccept = stripLeadingSlashInAccept;
    }

    public PathFilter(Pattern[] includes, Pattern[] excludes, boolean stripLeadingSlashInAccept) {
        this(stripLeadingSlashInAccept);
        this.includes = PathFilter.asList(includes);
        this.excludes = PathFilter.asList(excludes);
    }

    public boolean isAcceptAll() {
        return this.includes == null && this.excludes == null && this.includeLiterals == null && this.excludeLiterals == null;
    }

    public boolean accept(String path) {
        boolean accept;
        if (this.stripLeadingSlashInAccept && path.startsWith("/")) {
            path = path.substring(1);
        }
        if (this.includeLiterals != null || this.excludeLiterals != null) {
            path = PathFilter.normalizePath(path, this.stripLeadingSlashInAccept);
        }
        boolean bl = accept = this.includeLiterals == null && this.includes == null;
        if (!accept && this.includeLiterals != null) {
            boolean bl2 = accept = Collections.binarySearch(this.includeLiterals, path) >= 0;
        }
        if (!accept && this.includes != null) {
            for (Pattern inc : this.includes) {
                if (!inc.matcher(path).matches()) continue;
                accept = true;
                break;
            }
        }
        if (accept && this.excludeLiterals != null) {
            boolean bl3 = accept = Collections.binarySearch(this.excludeLiterals, path) < 0;
        }
        if (accept && this.excludes != null) {
            for (Pattern exc : this.excludes) {
                if (!exc.matcher(path).matches()) continue;
                accept = false;
                break;
            }
        }
        return accept;
    }
}

