/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.ItemTable;
import com.urbancode.codestation2.common.aggregate.ItemTableHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ItemTableRW
implements ItemTable {
    private ItemTableHeader header = new ItemTableHeader();
    private Map<String, AggregateItem> items = new LinkedHashMap<String, AggregateItem>();
    private boolean newTable = true;

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public AggregateItem get(String path) {
        if (!Aggregate.isPathValid(path = Aggregate.sanitizePath(path))) {
            throw new IllegalArgumentException("invalid path: " + path);
        }
        return this.items.get(path);
    }

    @Override
    public boolean isMetaOnly() {
        return this.header.isMetaOnly();
    }

    public void setMetaOnly(boolean metaOnly) {
        this.header.setMetaOnly(metaOnly);
    }

    public AggregateItem add(AggregateItem item) {
        assert (Aggregate.isPathValid(item.getPath()));
        AggregateItem prev = this.items.put(item.getPath(), item);
        this.header.setRecordCount(this.items.size());
        return prev;
    }

    public AggregateItem remove(String path) {
        if (!Aggregate.isPathValid(path = Aggregate.sanitizePath(path))) {
            throw new IllegalArgumentException("invalid path: " + path);
        }
        AggregateItem item = this.items.remove(path);
        this.header.setRecordCount(this.items.size());
        return item;
    }

    @Override
    public Iterator<AggregateItem> iterator() {
        final Iterator<AggregateItem> itr = this.items.values().iterator();
        return new Iterator<AggregateItem>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public AggregateItem next() {
                return (AggregateItem)itr.next();
            }

            @Override
            public void remove() {
                itr.remove();
                ItemTableRW.this.header.setRecordCount(ItemTableRW.this.items.size());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws IOException {
        BufferedInputStream in = null;
        while (true) {
            boolean existsBeforeOpen = file.isFile();
            try {
                in = new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                if (!existsBeforeOpen || !file.isFile()) continue;
                throw e;
                if (file.isFile()) continue;
            }
            break;
        }
        if (in == null) {
            this.header = new ItemTableHeader();
            this.items.clear();
            return;
        }
        try {
            this.read(in);
        }
        finally {
            in.close();
        }
    }

    public void read(InputStream in) throws IOException {
        ArrayList<AggregateItem> temp = new ArrayList<AggregateItem>();
        ItemTableHeader header = null;
        ObjectInputStream oin = new ObjectInputStream(in);
        try {
            header = (ItemTableHeader)oin.readObject();
            int count = header.getRecordCount();
            for (int i = 0; i < count; ++i) {
                AggregateItem item = null;
                try {
                    Object obj = oin.readObject();
                    if (obj instanceof AggregateItem) {
                        item = (AggregateItem)obj;
                    }
                }
                catch (ClassNotFoundException swallow) {
                    // empty catch block
                }
                if (item == null) continue;
                temp.add(item);
            }
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("invalid header").initCause(e);
        }
        catch (ClassCastException e) {
            throw (IOException)new IOException("invalid header").initCause(e);
        }
        if (header.getRecordCount() != temp.size()) {
            throw new IOException("invalid table: bad record count");
        }
        this.newTable = false;
        this.header = header;
        this.items.clear();
        for (AggregateItem i : temp) {
            assert (Aggregate.isPathValid(i.getPath()));
            this.items.put(i.getPath(), i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
            if (!parent.isDirectory()) {
                throw new IOException("Can't create directory " + parent.getAbsolutePath());
            }
        }
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            ArrayList<AggregateItem> temp = new ArrayList<AggregateItem>(this.items.values());
            Collections.sort(temp);
            out.writeObject(this.header);
            for (AggregateItem i : temp) {
                out.writeObject(i);
            }
        }
        finally {
            out.close();
        }
        this.newTable = false;
    }

    public boolean renameDataFiles(Map<String, String> renaming) throws IOException {
        if (new HashSet<String>((renaming = new HashMap<String, String>(renaming)).values()).size() != renaming.size()) {
            throw new IllegalArgumentException("renaming is not one-to-one");
        }
        boolean tableModified = false;
        for (AggregateItem item : this) {
            String oldName = item.getDataFileName();
            String newName = renaming.get(oldName);
            if (newName == null) continue;
            item.setDataFileName(newName);
            tableModified = true;
        }
        return tableModified;
    }

    boolean isNewTable() {
        return this.newTable;
    }

    int getRecordCount() {
        return this.header.getRecordCount();
    }
}

