/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.Sync;
import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.plugins.ucd.vfs.ApiCallHelper;
import com.urbancode.plugins.ucd.vfs.Util;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncLocalArtifactsCommand {
    private static AirPluginTool apTool;
    private static ApiCallHelper apiCallHelper;
    private static String resId;
    private static String serverUrl;

    public static void main(String[] args) throws Exception {
        apTool = new AirPluginTool(args[0], args[1]);
        apiCallHelper = new ApiCallHelper(apTool.getAuthTokenUsername(), apTool.getAuthToken());
        Properties props = apTool.getStepProperties();
        resId = props.getProperty("resId");
        serverUrl = Util.parseServerUrl(props.getProperty("serverUrl"));
        String fileIncludePatterns = props.getProperty("fileIncludePatterns");
        String fileExcludePatterns = props.getProperty("fileExcludePatterns");
        boolean setFileExecuteBits = Util.parseBoolean(props.getProperty("setFileExecuteBits"));
        boolean verifyFileIntegrity = Util.parseBoolean(props.getProperty("verifyFileIntegrity"));
        Charset charset = Util.getCharset(props);
        File baseDirectory = new File(".").getCanonicalFile();
        List<String> includes = Util.parseLines(fileIncludePatterns);
        List<String> excludes = Util.parseLines(fileExcludePatterns);
        if (baseDirectory.isFile()) {
            throw new IllegalArgumentException("Base directory " + baseDirectory + " is a file");
        }
        Util.configureLogging();
        ArrayList<String> versionNames = new ArrayList<String>();
        ArrayList<UUID> versionIds = new ArrayList<UUID>();
        for (VersionInfo info : SyncLocalArtifactsCommand.getVersions()) {
            versionNames.add(info.name);
            versionIds.add(info.id);
        }
        System.out.println("Syncing for versions: " + versionNames);
        if (versionIds.isEmpty()) {
            System.out.println("No versions found in inventory. Skipping sync operation.");
        } else {
            CodestationClient csClient = Util.getCodestationClient(serverUrl, false, apTool.getAuthTokenUsername(), apTool.getAuthToken());
            Sync op = new Sync(csClient, baseDirectory, versionIds);
            op.setIncludes(includes);
            op.setExcludes(excludes);
            op.setOutputCharset(charset);
            op.setSetExecuteBits(setFileExecuteBits);
            op.setVerifyFiles(verifyFileIntegrity);
            System.out.println("Syncing files in " + baseDirectory);
            System.out.println("Including " + includes);
            System.out.println("Excluding " + excludes);
            System.out.println();
            System.out.println();
            op.run();
        }
    }

    private static List<VersionInfo> getVersions() throws Exception {
        URI uri = new URIBuilder(serverUrl + "/rest/inventory/resourceInventory/table").addParameter("rowsPerPage", "1000000").addParameter("pageNumber", "1").addParameter("orderField", "dateCreated").addParameter("sortType", "desc").addParameter("filterFields", "resourceId").addParameter("filterValue_resourceId", resId).addParameter("filterType_resourceId", "eq").addParameter("filterClass_resourceId", "String").build();
        ApiCallHelper.HttpResult httpResult = apiCallHelper.callApi((HttpUriRequest)new HttpGet(uri), "getting version type");
        switch (httpResult.getCode()) {
            case 200: {
                HashSet<UUID> ids = new HashSet<UUID>();
                ArrayList<VersionInfo> versions = new ArrayList<VersionInfo>();
                JSONArray records = new JSONObject(httpResult.getContent()).getJSONArray("records");
                for (int i = records.length() - 1; i >= 0; --i) {
                    JSONObject record = records.getJSONObject(i);
                    JSONObject version = record.getJSONObject("version");
                    UUID id = UUID.fromString(version.getString("id"));
                    String name = version.getString("name");
                    if (!ids.add(id)) continue;
                    versions.add(new VersionInfo(id, name));
                }
                return versions;
            }
        }
        System.out.println("Unexpected HTTP status getting resource inventory: " + httpResult.getCode());
        System.exit(1);
        return null;
    }

    private static class VersionInfo {
        final UUID id;
        final String name;

        public VersionInfo(UUID id, String name) {
            this.id = id;
            this.id.getClass();
            this.name = name;
            this.name.getClass();
        }
    }
}

