/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.asm;

import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.ptrstore.PtrStore;
import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.ItemTableScanner;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.UUID;
import org.apache.log4j.Logger;

class AsmUsageEstimator {
    private final Logger log;
    private final PtrStore ptrStore;
    private final BlobManager bm;

    AsmUsageEstimator(Logger log, PtrStore ptrStore, BlobManager bm) {
        this.log = log;
        this.ptrStore = ptrStore;
        this.bm = bm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long estimate(UUID asid) throws IOException {
        UUID tableId = this.ptrStore.getBlobId(asid);
        if (tableId == null) {
            return -1L;
        }
        InputStream table = this.bm.openBlobLocal(tableId);
        if (table == null) {
            return 0L;
        }
        try {
            long usage;
            block11: {
                usage = 0L;
                long tableUsage = this.bm.estimateDiskUsage(tableId);
                if (tableUsage > 0L) {
                    usage += tableUsage;
                }
                try {
                    AggregateItem item;
                    HashSet<String> scanned = new HashSet<String>();
                    ItemTableScanner scanner = new ItemTableScanner(table);
                    while ((item = scanner.read()) != null) {
                        UUID dataId;
                        String name = item.getDataFileName();
                        if (Aggregate.isSpecialDataFile((String)name) || scanned.contains(name)) continue;
                        scanned.add(name);
                        try {
                            dataId = UUID.fromString(name);
                        }
                        catch (IllegalArgumentException e) {
                            this.log.warn((Object)String.format("Data blob ID invalid: artifactSetId=%s, id=%s", asid, name));
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug((Object)"Stack trace", (Throwable)e);
                            continue;
                        }
                        long dataUsage = this.bm.estimateDiskUsage(dataId);
                        if (dataUsage <= 0L) continue;
                        usage += dataUsage;
                    }
                }
                catch (IOException e) {
                    this.log.warn((Object)("Table blob invalid: artifactSetId=" + asid), (Throwable)e);
                    if (!this.log.isDebugEnabled()) break block11;
                    this.log.debug((Object)"Stack trace", (Throwable)e);
                }
            }
            long l = usage;
            return l;
        }
        finally {
            table.close();
        }
    }
}

