/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.blobstore;

import com.ibm.uclab.csrepl.blobstore.BlobMetadata;
import com.ibm.uclab.csrepl.blobstore.BlobStoreImpl;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.UUID;

class BlobMetadataIterator
implements Iterator<BlobMetadata> {
    private final BlobStoreImpl store;
    private Iterator<File> fanoutDirItr;
    private Iterator<File> blobItr;
    private BlobMetadata current;

    BlobMetadataIterator(BlobStoreImpl store) {
        this.store = store;
        this.fanoutDirItr = this.list(store.getDataDir());
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.current == null) {
                this.advance();
            }
            return this.current != null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BlobMetadata next() {
        try {
            if (this.current == null) {
                this.advance();
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
            }
            BlobMetadata c = this.current;
            this.current = null;
            return c;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void advance() throws IOException {
        if (this.fanoutDirItr == null) {
            return;
        }
        while (true) {
            if (this.blobItr == null) {
                if (!this.fanoutDirItr.hasNext()) {
                    this.fanoutDirItr = null;
                    return;
                }
                File dir = this.fanoutDirItr.next();
                if (!this.isFanoutDir(dir)) continue;
                this.blobItr = this.list(dir);
                if (this.blobItr == null) continue;
            }
            if (!this.blobItr.hasNext()) {
                this.blobItr = null;
                continue;
            }
            File blob = this.blobItr.next();
            UUID id = this.getId(blob);
            if (id == null) continue;
            this.current = this.store.getBlobMeta(id);
            if (this.current != null) break;
        }
    }

    private boolean isFanoutDir(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        String name = dir.getName();
        if (name.length() != 2) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (this.isHex(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private Iterator<File> list(File dir) {
        File[] list = dir.listFiles();
        if (list == null) {
            return null;
        }
        return Arrays.asList(list).iterator();
    }

    private UUID getId(File file) {
        String name = file.getName();
        if (name.length() != 36) {
            return null;
        }
        try {
            return UUID.fromString(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }
}

