/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.AggregateInputStream;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import java.io.IOException;
import java.io.RandomAccessFile;

class AggregateInputStreamRA
extends AggregateInputStream {
    private final AggregateItem item;
    private volatile RandomAccessFile in;
    private long length;

    AggregateInputStreamRA(AggregateItem item, RandomAccessFile in) throws IOException {
        this.item = item;
        this.in = in;
        this.length = item.getLength();
        in.seek(item.getOffset());
    }

    @Override
    public AggregateItem getItem() {
        return this.item;
    }

    @Override
    public synchronized int read() throws IOException {
        RandomAccessFile i = this.in;
        if (i == null) {
            throw new IOException("stream closed");
        }
        if (this.length <= 0L) {
            return -1;
        }
        int b = i.read();
        if (b != -1) {
            --this.length;
        }
        if (b == -1 && this.length > 0L) {
            throw new IOException("stream truncated");
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        RandomAccessFile i = this.in;
        if (i == null) {
            throw new IOException("stream closed");
        }
        if (this.length <= 0L) {
            return -1;
        }
        int r = i.read(b, off, len = (int)Math.min(this.length, (long)len));
        if (r != -1) {
            this.length -= (long)r;
        }
        if (r == -1 && this.length > 0L) {
            throw new IOException("stream truncated");
        }
        return r;
    }

    @Override
    public void close() throws IOException {
        RandomAccessFile i = this.in;
        this.in = null;
        if (i != null) {
            i.close();
        }
    }
}

