/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.Download;
import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.commons.util.processes.Processes;
import com.urbancode.plugins.ucd.vfs.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Future;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;

public class DownloadForZosCommand {
    static final String PACKAGE_ZIP = "package.zip";
    static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";
    static final String ENCODING_CP037 = "CP037";
    static final String MANIFEST_NODE = "manifest";
    static final String MANIFEST_VERSION_ATTRIBUTE = "version";
    static final int ERR_CODE = 1;

    public static void main(String[] args) throws Exception {
        File zipFile;
        File workDir;
        AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
        Properties props = apTool.getStepProperties();
        String repositoryType = StringUtils.trimToNull((String)props.getProperty("repositoryType"));
        String versionName = StringUtils.trimToNull((String)props.getProperty("versionName"));
        UUID versionId = UUID.fromString(StringUtils.trimToNull((String)props.getProperty("versionId")));
        String resourceId = StringUtils.trimToNull((String)props.getProperty("resourceId"));
        String directoryOffset = StringUtils.trimToNull((String)props.getProperty("directoryOffset"));
        String serverUrl = Util.parseServerUrl(props.getProperty("serverUrl"));
        Charset charset = Util.getCharset(props);
        if (!"CODESTATION".equalsIgnoreCase(repositoryType)) {
            if ("HFS".equalsIgnoreCase(repositoryType)) {
                System.out.println("Version " + versionName + "(" + versionId + ") is stored in zOS HFS. Use Copy Artifacts or FTP Artifacts plug-in steps to retrieve the version artifacts.");
            } else {
                System.out.println("Version " + versionName + "(" + versionId + ") is not stored in CodeStation.");
            }
            System.out.println("Download failed.");
            System.exit(1);
        }
        File baseDirectory = workDir = new File("." + File.separator + resourceId + File.separator + versionName).getCanonicalFile();
        if (directoryOffset != null) {
            baseDirectory = new File(workDir, directoryOffset).getCanonicalFile();
        }
        if (baseDirectory.exists() && baseDirectory.isDirectory()) {
            System.out.println("Deleting base directory - " + baseDirectory);
            Util.deleteDir(baseDirectory);
        }
        baseDirectory.mkdirs();
        if (baseDirectory.isFile()) {
            throw new IllegalArgumentException("Base directory " + baseDirectory + " is a file");
        }
        Util.configureLogging();
        CodestationClient csClient = Util.getCodestationClient(serverUrl, false, apTool.getAuthTokenUsername(), apTool.getAuthToken());
        Download op = new Download(csClient, baseDirectory, versionId);
        op.setIncludes(Arrays.asList(PACKAGE_ZIP, PACKAGE_MANIFEST_XML));
        op.setOutputCharset(charset);
        System.out.println("Artifact source: " + csClient.getUrl());
        System.out.println("Working directory: " + baseDirectory);
        System.out.println("Offset " + directoryOffset);
        System.out.println();
        op.run();
        File pkgManifestFile = new File(baseDirectory, PACKAGE_MANIFEST_XML);
        if (!pkgManifestFile.exists()) {
            System.out.println("Error: packageManifest.xml not found in CodeStation");
            System.exit(1);
        }
        if (DownloadForZosCommand.isSecondVersion(pkgManifestFile.getCanonicalPath()) && (zipFile = new File(baseDirectory, PACKAGE_ZIP)).exists()) {
            Processes processes = new Processes();
            String[] cmdArgs = new String[]{"pax", "-r", "-vf", zipFile.getPath()};
            Process process = new ProcessBuilder(cmdArgs).directory(baseDirectory).start();
            process.getOutputStream().close();
            Future<String> sout = processes.getOutputStringFuture(process);
            Future<String> serr = processes.getErrorStringFuture(process);
            process.waitFor();
            if (process.exitValue() > 0) {
                System.out.println("Error while extracting files from package.zip");
                System.exit(1);
            }
            try {
                zipFile.renameTo(new File(baseDirectory, "processed_package.zip"));
            }
            catch (Exception e) {
                System.out.println("Error while renaming the package.zip file");
                e.printStackTrace();
                System.exit(1);
            }
            System.out.println("Deployment package extracted successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSecondVersion(String manifestPath) throws IOException, XMLStreamException {
        FileInputStream shipListFileStream = null;
        boolean manifestNodeFound = false;
        boolean isNewPackage = false;
        try {
            shipListFileStream = new FileInputStream(manifestPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader shiplistEventReader = inputFactory.createXMLEventReader(shipListFileStream, ENCODING_CP037);
        try {
            while (shiplistEventReader.hasNext() && !manifestNodeFound) {
                XMLEvent shipListReaderEvent = shiplistEventReader.nextEvent();
                switch (shipListReaderEvent.getEventType()) {
                    case 1: {
                        StartElement startElement = shipListReaderEvent.asStartElement();
                        String nodeName = startElement.getName().getLocalPart().trim();
                        if (!MANIFEST_NODE.equalsIgnoreCase(nodeName)) break;
                        String versionValue = DownloadForZosCommand.getAttributeValue(startElement, MANIFEST_VERSION_ATTRIBUTE);
                        manifestNodeFound = true;
                        if (versionValue != null && versionValue.equals("v2_0")) {
                            isNewPackage = true;
                            break;
                        }
                        isNewPackage = false;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                shipListFileStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        return isNewPackage;
    }

    private static String getAttributeValue(StartElement startElement, String attributeName) {
        if (null == startElement || null == attributeName) {
            return null;
        }
        Iterator<Attribute> it = startElement.getAttributes();
        while (it.hasNext()) {
            String value;
            Attribute attr = it.next();
            if (!attr.getName().getLocalPart().trim().equalsIgnoreCase(attributeName) || null == (value = attr.getValue())) continue;
            return value.trim();
        }
        return null;
    }
}

