/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateInputStream;
import com.urbancode.codestation2.common.aggregate.AggregateInputStreamSH;
import com.urbancode.codestation2.common.aggregate.AggregateInputStreamZero;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.AggregateReader;
import com.urbancode.codestation2.common.aggregate.ItemTable;
import com.urbancode.codestation2.common.aggregate.SharedFileReader;
import com.urbancode.codestation2.common.aggregate.StreamFactoryFS;
import com.urbancode.codestation2.common.aggregate.streams.StreamFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

class AggregateReaderImpl
extends AggregateReader
implements Closeable {
    private String fileName;
    private SharedFileReader in;
    private StreamFactory factory;

    AggregateReaderImpl(File dir, ItemTable table, StreamFactory factory) {
        super(table);
        if (factory == null) {
            factory = new StreamFactoryFS(dir);
        }
        this.factory = factory;
    }

    @Override
    public AggregateInputStream read(String path) throws IOException {
        if (this.table == null) {
            throw new IOException("reader closed");
        }
        if (!Aggregate.isPathValid(path = Aggregate.sanitizePath(path))) {
            throw new IllegalArgumentException("invalid path: " + path);
        }
        AggregateItem item = this.table.get(path);
        if (item == null) {
            return null;
        }
        return this.read(item);
    }

    @Override
    public AggregateInputStream read(AggregateItem item) throws IOException {
        assert (item == this.table.get(item.getPath()));
        if (item.isMetaOnly() || ".urbancode-zero".equals(item.getDataFileName())) {
            return new AggregateInputStreamZero(item);
        }
        SharedFileReader in = new SharedFileReader(this.factory.openInput(item.getDataFileName()));
        return new AggregateInputStreamSH(item, in);
    }

    @Override
    public AggregateInputStream read() throws IOException {
        if (this.table == null) {
            throw new IOException("reader closed");
        }
        if (this.iterator.hasNext()) {
            AggregateItem item = (AggregateItem)this.iterator.next();
            return this.open(item);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        SharedFileReader i = this.in;
        this.in = null;
        this.fileName = null;
        this.table = null;
        this.iterator = null;
        if (i != null) {
            i.decref();
        }
    }

    private AggregateInputStream open(AggregateItem item) throws IOException {
        if (item.isMetaOnly() || ".urbancode-zero".equals(item.getDataFileName())) {
            return new AggregateInputStreamZero(item);
        }
        if (this.fileName == null || !this.fileName.equals(item.getDataFileName())) {
            SharedFileReader i = this.in;
            this.fileName = null;
            this.in = null;
            if (i != null) {
                i.decref();
            }
            i = new SharedFileReader(this.factory.openInput(item.getDataFileName()));
            i.incref();
            this.in = i;
            this.fileName = item.getDataFileName();
        }
        return new AggregateInputStreamSH(item, this.in);
    }
}

