/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.asm;

import com.ibm.uclab.csrepl.asm.AsmConnector;
import com.ibm.uclab.csrepl.ptrstore.IDMappingReader;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class AsmConnectorMerging
implements AsmConnector {
    private final AsmConnector conn;
    private final ConcurrentHashMap<UUID, Future<UUID>> active;

    public AsmConnectorMerging(AsmConnector conn) {
        this.conn = conn;
        this.active = new ConcurrentHashMap(16, 0.75f, 4);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.conn + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID getBlobId(UUID localId, UUID artifactSetId) throws IOException {
        Future oldFut;
        UUID blobId = null;
        FutureTask<UUID> newFut = this.createFuture(localId, artifactSetId);
        while ((oldFut = (Future)this.active.putIfAbsent(artifactSetId, newFut)) != null) {
            blobId = this.getWithOldFuture(oldFut);
            if (blobId != null) {
                return blobId;
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            return null;
        }
        try {
            UUID uUID = this.getWithNewFuture(newFut);
            return uUID;
        }
        finally {
            this.active.remove(artifactSetId, newFut);
        }
    }

    @Override
    public IDMappingReader getMappingReader(UUID localId) throws IOException {
        return this.conn.getMappingReader(localId);
    }

    @Override
    public void start() {
        this.conn.start();
    }

    @Override
    public void stop() {
        this.conn.stop();
    }

    private FutureTask<UUID> createFuture(final UUID localId, final UUID artifactSetId) {
        Callable<UUID> c = new Callable<UUID>(){

            @Override
            public UUID call() throws IOException {
                return AsmConnectorMerging.this.conn.getBlobId(localId, artifactSetId);
            }
        };
        return new FutureTask<UUID>(c);
    }

    private UUID getWithOldFuture(Future<UUID> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    private UUID getWithNewFuture(FutureTask<UUID> future) throws IOException {
        try {
            future.run();
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new IOException(e.getMessage(), e);
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IOException(cause.getMessage(), cause);
        }
    }
}

