/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.blobstore;

import java.util.Comparator;
import java.util.UUID;

public class BlobMetadata {
    private final long idMsb;
    private final long idLsb;
    private final long lastAccessed;
    private final long length;

    public static Comparator<BlobMetadata> byId() {
        return new Comparator<BlobMetadata>(){

            @Override
            public int compare(BlobMetadata m1, BlobMetadata m2) {
                if (m1.idMsb < m2.idMsb) {
                    return -1;
                }
                if (m1.idMsb > m2.idMsb) {
                    return 1;
                }
                if (m1.idLsb < m2.idLsb) {
                    return -1;
                }
                if (m1.idLsb == m2.idLsb) {
                    return 0;
                }
                return 1;
            }
        };
    }

    public static Comparator<BlobMetadata> byLastAccess() {
        return new Comparator<BlobMetadata>(){

            @Override
            public int compare(BlobMetadata m1, BlobMetadata m2) {
                if (m1.lastAccessed < m2.lastAccessed) {
                    return -1;
                }
                if (m1.lastAccessed == m2.lastAccessed) {
                    return 0;
                }
                return 1;
            }
        };
    }

    public static Comparator<BlobMetadata> byLength() {
        return new Comparator<BlobMetadata>(){

            @Override
            public int compare(BlobMetadata m1, BlobMetadata m2) {
                if (m1.length < m2.length) {
                    return -1;
                }
                if (m1.length == m2.length) {
                    return 0;
                }
                return 1;
            }
        };
    }

    public BlobMetadata(UUID id, long lastAccessed, long length) {
        this(id.getMostSignificantBits(), id.getLeastSignificantBits(), lastAccessed, length);
    }

    BlobMetadata(long idMsb, long idLsb, long lastAccessed, long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("size: " + size);
        }
        this.idMsb = idMsb;
        this.idLsb = idLsb;
        this.lastAccessed = lastAccessed;
        this.length = size;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlobMetadata) {
            BlobMetadata rhs = (BlobMetadata)obj;
            return this.idMsb == rhs.idMsb && this.idLsb == rhs.idLsb && this.lastAccessed == rhs.lastAccessed && this.length == rhs.length;
        }
        return false;
    }

    public int hashCode() {
        int hash = 13;
        hash = 31 * hash + (int)(this.idMsb ^ this.idMsb >>> 32);
        hash = 31 * hash + (int)(this.idLsb ^ this.idLsb >>> 32);
        hash = 31 * hash + (int)(this.lastAccessed ^ this.lastAccessed >>> 32);
        hash = 31 * hash + (int)(this.length ^ this.length >>> 32);
        return hash;
    }

    public String toString() {
        return this.getId() + "," + this.lastAccessed + "," + this.length;
    }

    public UUID getId() {
        return new UUID(this.idMsb, this.idLsb);
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public long getLength() {
        return this.length;
    }

    long getIdMsb() {
        return this.idMsb;
    }

    long getIdLsb() {
        return this.idLsb;
    }
}

