/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.blobstore;

import com.ibm.uclab.csrepl.blobstore.BlobReplicator;
import com.ibm.uclab.csrepl.blobstore.BlobReplicatorStream;
import com.ibm.uclab.csrepl.blobstore.BlobStoreImpl;
import com.ibm.uclab.csrepl.blobstore.DiskUsageEstimator;
import com.ibm.uclab.csrepl.lifecycle.LifecycleStoppedException;
import com.ibm.uclab.csrepl.moveable.MoveableFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;

class BlobReplicatorImpl
implements BlobReplicator {
    private static final Logger log = Logger.getLogger(BlobReplicatorImpl.class);
    private final BlobStoreImpl store;
    private final UUID id;
    private final InputStream in;
    private final OutputStream out;
    private final long length;
    private boolean done;
    private List<BlobReplicatorStream> streams;
    private IOException error;

    BlobReplicatorImpl(BlobStoreImpl store, UUID id, InputStream in, OutputStream out, long length) {
        if (length < -1L) {
            throw new IllegalArgumentException("invalid length: " + length);
        }
        this.store = store;
        this.id = id;
        this.in = in;
        this.out = out;
        this.length = length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread t = Thread.currentThread();
        String name = t.getName();
        try {
            t.setName(name + ": replicator[" + this.id + "]");
            try {
                this.doReplicate();
            }
            catch (LifecycleStoppedException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Stopped", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"Replication failed", (Throwable)e);
            }
            finally {
                this.store.unregisterReplicator(this);
            }
        }
        finally {
            t.setName(name);
        }
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public synchronized InputStream open() throws IOException {
        if (this.done) {
            return null;
        }
        MoveableFileInputStream temp = this.store.openTempForInput(this.id);
        BlobReplicatorStream s = new BlobReplicatorStream(this, temp, this.length);
        if (this.streams == null) {
            this.streams = new ArrayList<BlobReplicatorStream>();
        }
        this.streams.add(s);
        return s;
    }

    @Override
    public synchronized long estimateDiskUsage(DiskUsageEstimator est, File file) throws IOException {
        if (this.done) {
            return -1L;
        }
        long length = est.estimateFromFile(file);
        if (length == 0L && !file.exists()) {
            return -1L;
        }
        return length;
    }

    synchronized void unregisterStream(BlobReplicatorStream is) {
        if (this.streams != null) {
            this.streams.remove((Object)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doReplicate() throws IOException {
        try {
            try {
                try {
                    long total = 0L;
                    try {
                        int n;
                        byte[] buffer = new byte[8192];
                        while ((n = this.in.read(buffer)) != -1) {
                            this.out.write(buffer, 0, n);
                            this.update(total += (long)n);
                        }
                        if (this.length != -1L && this.length != total) {
                            throw new InconsistentBlobLengthException(String.format("blob length inconsistent: id=%s expected=%d actual=%d", this.id, this.length, total));
                        }
                    }
                    finally {
                        this.out.close();
                    }
                    this.finish(total);
                }
                catch (IOException e) {
                    this.finish(e);
                }
                finally {
                    this.store.deleteTempFile(this.id);
                }
            }
            finally {
                this.in.close();
            }
        }
        finally {
            this.store.unregisterReplicator(this);
        }
    }

    private synchronized void update(long total) {
        List<BlobReplicatorStream> ss = this.streams;
        if (ss != null) {
            for (BlobReplicatorStream s : ss) {
                s.update(total);
            }
        }
    }

    private synchronized void finish(IOException error) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Replication completed with error", (Throwable)error);
        }
        this.done = true;
        this.error = error;
        BlobReplicatorStream[] running = this.clearStreams();
        if (running != null) {
            for (BlobReplicatorStream element : running) {
                element.fail(error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void finish(long total) {
        block13: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Replication completed without error");
            }
            this.done = true;
            BlobReplicatorStream[] running = this.clearStreams();
            IOException[] moveErrors = null;
            if (running != null) {
                moveErrors = new IOException[running.length];
                for (int i = 0; i < running.length; ++i) {
                    try {
                        running[i].preMove();
                        continue;
                    }
                    catch (IOException e) {
                        moveErrors[i] = e;
                        log.error((Object)"Error pre-moving running stream", (Throwable)e);
                    }
                }
            }
            IOException commitError = null;
            File newFile = null;
            try {
                newFile = this.store.commitTempFile(this.id);
            }
            catch (IOException e) {
                commitError = e;
            }
            finally {
                if (running == null) break block13;
                for (int i = 0; i < running.length; ++i) {
                    if (moveErrors[i] == null && commitError == null) {
                        running[i].postMove(total, newFile);
                        continue;
                    }
                    if (moveErrors[i] != null) {
                        running[i].fail(moveErrors[i]);
                        continue;
                    }
                    running[i].fail(commitError);
                }
            }
        }
    }

    private BlobReplicatorStream[] clearStreams() {
        BlobReplicatorStream[] running = null;
        if (this.streams != null) {
            running = this.streams.toArray(new BlobReplicatorStream[this.streams.size()]);
            this.streams = null;
        }
        return running;
    }

    synchronized IOException getError() {
        return this.error;
    }

    public static class InconsistentBlobLengthException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public InconsistentBlobLengthException() {
        }

        public InconsistentBlobLengthException(String message, Throwable cause) {
            super(message, cause);
        }

        public InconsistentBlobLengthException(String message) {
            super(message);
        }

        public InconsistentBlobLengthException(Throwable cause) {
            super(cause);
        }
    }
}

