/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.blobstore;

import com.ibm.uclab.csrepl.blobstore.DiskUsageEstimator;
import java.io.File;
import java.io.IOException;

public class DiskUsageEstimatorImpl
implements DiskUsageEstimator {
    private final int blockSize;

    public DiskUsageEstimatorImpl() {
        this(4096);
    }

    public DiskUsageEstimatorImpl(int blockSize) {
        if (blockSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.blockSize = blockSize;
    }

    @Override
    public long estimateFromFile(File file) throws IOException {
        return this.estimateFromLength(file.length());
    }

    @Override
    public long estimateFromLength(long length) {
        if (length < 0L) {
            throw new IllegalArgumentException();
        }
        long blocks = (length + (long)this.blockSize - 1L) / (long)this.blockSize;
        return (long)this.blockSize * blocks;
    }
}

