/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.ibm.uclab.csrepl.codestation.FileMetadata;
import java.io.IOException;
import java.io.InputStream;

public class CodestationInputStream
extends InputStream {
    private final InputStream in;
    private final FileMetadata meta;

    public CodestationInputStream(InputStream in, FileMetadata meta) {
        this.in = in;
        this.meta = meta;
    }

    public FileMetadata getMeta() {
        return this.meta;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.in.read();
        }
        catch (IOException e) {
            throw this.enhance(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.in.read(b, off, len);
        }
        catch (IOException e) {
            throw this.enhance(e);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return this.in.skip(n);
        }
        catch (IOException e) {
            throw this.enhance(e);
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.in.available();
        }
        catch (IOException e) {
            throw this.enhance(e);
        }
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.in.reset();
        }
        catch (IOException e) {
            throw this.enhance(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw this.enhance(e);
        }
    }

    private IOException enhance(IOException e) {
        FileMetadata m = this.meta;
        if (m == null) {
            return e;
        }
        String path = m.getPath();
        if (path == null) {
            return e;
        }
        String msg = e.getMessage();
        if (msg == null) {
            msg = "Unknown error";
        }
        msg = msg + ": " + path;
        return new IOException(msg, e);
    }
}

