/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.codestation.CodestationInputStream;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.codestation.StreamFactoryArtifactSet;
import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateInputStream;
import com.urbancode.codestation2.common.aggregate.AggregateReaderFactory;
import com.urbancode.codestation2.common.aggregate.streams.StreamFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;

public class CodestationServiceImplOpenFile {
    private final ArtifactSetManager artifactSetManager;
    private final BlobManager blobManager;
    private final AggregateReaderFactory readerFactory;
    private final UUID artifactSetId;
    private final String path;

    public CodestationServiceImplOpenFile(ArtifactSetManager artifactSetManager, BlobManager blobManager, UUID artifactSetId, String path) {
        this(artifactSetManager, blobManager, null, artifactSetId, path);
    }

    public CodestationServiceImplOpenFile(ArtifactSetManager artifactSetManager, BlobManager blobManager, AggregateReaderFactory readerFactory, UUID artifactSetId, String path) {
        path = Aggregate.sanitizePath((String)path);
        if (!Aggregate.isPathValid((String)path)) {
            throw new IllegalArgumentException("invalid path");
        }
        this.artifactSetManager = artifactSetManager;
        this.artifactSetManager.getClass();
        this.blobManager = blobManager;
        this.blobManager.getClass();
        this.artifactSetId = artifactSetId;
        this.artifactSetId.getClass();
        this.readerFactory = readerFactory;
        this.path = path;
    }

    public CodestationInputStream run() throws IOException {
        StreamFactoryArtifactSet streamFactory = new StreamFactoryArtifactSet(this.artifactSetManager, this.blobManager, this.artifactSetId);
        Aggregate aggr = Aggregate.createReadOnlyStreaming((StreamFactory)streamFactory, (AggregateReaderFactory)this.readerFactory);
        AggregateInputStream in = aggr.read(this.path);
        if (in == null) {
            try {
                String p = new String(this.path.getBytes("ISO-8859-1"), "UTF-8");
                in = aggr.read(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (in == null) {
            throw new FileNotFoundException(String.format("No file for path: artifactSetId=%s, path=%s", this.artifactSetId, this.path));
        }
        return new CodestationInputStream((InputStream)in, new FileMetadata(in.getItem()));
    }
}

