/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.urbancode.codestation2.common.aggregate.PathFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class Filter {
    private final String[] includes;
    private final String[] excludes;
    private boolean implInited;
    private PathFilter impl;

    public static Filter fromJSON(String json) throws JSONException {
        ArrayList<String> includes = new ArrayList<String>();
        JSONObject jo = new JSONObject(json);
        if (jo.has("includes")) {
            JSONArray incs = jo.getJSONArray("includes");
            for (int i = 0; i < incs.length(); ++i) {
                String s;
                if (incs.isNull(i) || (s = incs.getString(i).trim()).length() <= 0) continue;
                includes.add(s);
            }
        }
        ArrayList<String> excludes = new ArrayList<String>();
        if (jo.has("excludes")) {
            JSONArray excs = jo.getJSONArray("excludes");
            for (int i = 0; i < excs.length(); ++i) {
                String s;
                if (excs.isNull(i) || (s = excs.getString(i).trim()).length() <= 0) continue;
                excludes.add(s);
            }
        }
        return Filter.compile(includes, excludes);
    }

    public static Filter compile(String ... includes) {
        return Filter.compile(Arrays.asList(includes), null);
    }

    public static Filter compile(List<String> includes, List<String> excludes) {
        String[] incs = null;
        incs = includes == null ? new String[]{} : includes.toArray(new String[includes.size()]);
        String[] excs = null;
        excs = excludes == null ? new String[]{} : excludes.toArray(new String[excludes.size()]);
        return new Filter(incs, excs);
    }

    private Filter(String[] includes, String[] excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public List<String> getIncludes() {
        return Collections.unmodifiableList(Arrays.asList(this.includes));
    }

    public List<String> getExcludes() {
        return Collections.unmodifiableList(Arrays.asList(this.excludes));
    }

    public boolean accept(String path) {
        this.initImpl();
        if (this.impl == null) {
            return true;
        }
        return this.impl.accept(path);
    }

    public JSONObject toJSON() {
        try {
            ArrayList<String> incs = new ArrayList<String>();
            ArrayList<String> excs = new ArrayList<String>();
            for (String s : this.includes) {
                if (s == null || (s = s.trim()).length() <= 0) continue;
                incs.add(s);
            }
            for (String s : this.excludes) {
                if (s == null || (s = s.trim()).length() <= 0) continue;
                excs.add(s);
            }
            JSONObject jo = new JSONObject();
            if (!incs.isEmpty()) {
                jo.put("includes", (Object)new JSONArray(incs));
            }
            if (!excs.isEmpty()) {
                jo.put("excludes", (Object)new JSONArray(excs));
            }
            return jo;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public Filter withPrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return this;
        }
        String[] inc = this.prefixPatterns(prefix, this.includes);
        String[] exc = this.prefixPatterns(prefix, this.excludes);
        if (inc == null) {
            inc = new String[]{prefix + "/**/*"};
        }
        if (exc == null) {
            exc = new String[]{};
        }
        return new Filter(inc, exc);
    }

    PathFilter toPathFilter() {
        if (this.implInited && this.impl != null) {
            return this.impl;
        }
        return PathFilter.compile((String[])this.includes, (String[])this.excludes, (boolean)false);
    }

    private void initImpl() {
        if (!this.implInited) {
            PathFilter pf = this.toPathFilter();
            if (pf.isAcceptAll()) {
                pf = null;
            }
            this.implInited = true;
            this.impl = pf;
        }
    }

    private String[] prefixPatterns(String prefix, String[] pat) {
        if (pat == null || pat.length == 0) {
            return null;
        }
        pat = (String[])pat.clone();
        for (int i = 0; i < pat.length; ++i) {
            pat[i] = prefix + "/" + pat[i];
        }
        return pat;
    }
}

