/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.exceptions;

import com.ibm.uclab.csrepl.exceptions.AuthenticationException;
import com.ibm.uclab.csrepl.exceptions.AuthorizationException;
import com.ibm.uclab.csrepl.exceptions.ServerFailedException;
import com.ibm.uclab.csrepl.exceptions.ServerUnavailableException;
import com.ibm.uclab.csrepl.exceptions.UpstreamServerFailedException;
import com.ibm.uclab.csrepl.exceptions.UpstreamServerUnavailableException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class Errors {
    private final Logger log;

    public Errors(Logger log) {
        log.getClass();
        this.log = log;
    }

    public IOException defaultArtifactSetErrorSwitch(UUID artifactSetId, CallResult result) {
        return this.defaultErrorSwitch0(artifactSetId, "Artifact set", result);
    }

    public IOException defaultBlobErrorSwitch(UUID blobId, CallResult result) {
        return this.defaultErrorSwitch0(blobId, "Blob", result);
    }

    private IOException defaultErrorSwitch0(UUID id, String object, CallResult result) {
        int status = result.res.getStatusLine().getStatusCode();
        switch (status) {
            case 401: {
                return this.notAuthenticated(id, result);
            }
            case 403: {
                return this.notAuthorized(id, result);
            }
            case 404: {
                return this.notFound(id, object, result);
            }
            case 502: {
                return this.upstreamServerFailed(id, result);
            }
            case 503: {
                return this.serverUnavailable(id, result);
            }
            case 504: {
                return this.upstreamServerUnavailable(id, result);
            }
        }
        if (status >= 500 && status < 600) {
            return this.serverFailed(id, result);
        }
        return this.unacceptableResponse(result);
    }

    private ServerFailedException serverFailed(UUID artifactSetId, CallResult result) {
        return new ServerFailedException(this.formatErrorMessage("Server failed", artifactSetId, result));
    }

    private UpstreamServerFailedException upstreamServerFailed(UUID artifactSetId, CallResult result) {
        return new UpstreamServerFailedException(this.formatErrorMessage("Upstream server failed", artifactSetId, result));
    }

    private UpstreamServerUnavailableException upstreamServerUnavailable(UUID artifactSetId, CallResult result) {
        return new UpstreamServerUnavailableException(this.formatErrorMessage("Upstream server unavailable", artifactSetId, result));
    }

    private ServerUnavailableException serverUnavailable(UUID artifactSetId, CallResult result) {
        return new ServerUnavailableException(this.formatErrorMessage("Server unavailable", artifactSetId, result));
    }

    private AuthenticationException notAuthenticated(UUID artifactSetId, CallResult result) {
        return new AuthenticationException(this.formatErrorMessage("Authentication failed", artifactSetId, result));
    }

    private AuthorizationException notAuthorized(UUID artifactSetId, CallResult result) {
        return new AuthorizationException(this.formatErrorMessage("Not authorized. Check permissions and Version Integrity settings", artifactSetId, result));
    }

    private FileNotFoundException notFound(UUID artifactSetId, String object, CallResult result) {
        if (this.log.isDebugEnabled()) {
            StatusLine status = result.res.getStatusLine();
            String error = this.getErrorMessage(result.res);
            error = error == null ? "" : ": " + error;
            this.log.debug((Object)String.format("Request failed with not found: %s %s: %03d %s%s", result.method, result.reqUrl, status.getStatusCode(), status.getReasonPhrase(), error));
        }
        return new FileNotFoundException(String.format("%s not found: %s%n%s URL: %s", object, artifactSetId, result.method, result.reqUrl));
    }

    private IOException unacceptableResponse(CallResult result) {
        String error = this.getErrorMessage(result.res);
        error = error == null ? "" : ": " + error;
        StatusLine status = result.res.getStatusLine();
        String message = String.format("Unacceptable response: %s %s: %03d %s%s", result.method, result.reqUrl, status.getStatusCode(), status.getReasonPhrase(), error);
        this.log.debug((Object)message);
        return new IOException(message);
    }

    private String getErrorMessage(HttpResponse res) {
        try {
            HttpEntity ent = res.getEntity();
            if (ent == null) {
                return null;
            }
            Header hd = ent.getContentType();
            if (hd == null) {
                return null;
            }
            String val = hd.getValue();
            if (val == null) {
                return null;
            }
            ContentType ct = ContentType.parse((String)val);
            if (ct == null) {
                return null;
            }
            if (!"text/plain".equalsIgnoreCase(ct.getMimeType())) {
                return null;
            }
            return EntityUtils.toString((HttpEntity)ent);
        }
        catch (ParseException parseException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String formatErrorMessage(String message, UUID artifactSetId, CallResult result) {
        if (this.log.isDebugEnabled()) {
            StatusLine status = result.res.getStatusLine();
            String error = this.getErrorMessage(result.res);
            error = error == null ? "" : ": " + error;
            this.log.debug((Object)String.format("Request failed: %s: %s %s: %03d %s%s", message, result.method, result.reqUrl, status.getStatusCode(), status.getReasonPhrase(), error));
        }
        return String.format("%s: %s%n%s URL: %s", message, artifactSetId, result.method, result.reqUrl);
    }

    public static class CallResult {
        public final String method;
        public final String reqUrl;
        public final HttpRequestBase req;
        public final HttpResponse res;

        public CallResult(String method, String reqUrl, HttpRequestBase req, HttpResponse res) {
            this.method = method;
            this.reqUrl = reqUrl;
            this.req = req;
            this.res = res;
        }
    }
}

