/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.http.range;

import com.ibm.uclab.csrepl.http.range.ByteRange;
import com.urbancode.commons.util.Check;

public class ByteContentRange {
    private final ByteRange range;
    private final long entityLength;

    public static ByteContentRange forKnownLengthEntity(ByteRange range, long entityLength) {
        Check.positive((long)entityLength);
        if (!range.isContentRangeCompatible()) {
            throw new IllegalArgumentException();
        }
        if (!range.isSatisfiable(entityLength)) {
            throw new IllegalArgumentException();
        }
        return new ByteContentRange(range, entityLength);
    }

    public static ByteContentRange forUnknownLengthEntity(ByteRange range) {
        if (!range.isContentRangeCompatible()) {
            throw new IllegalArgumentException();
        }
        return new ByteContentRange(range, -1L);
    }

    public static ByteContentRange forUnsatisfiedRange(long entityLength) {
        Check.positive((long)entityLength);
        return new ByteContentRange(null, entityLength);
    }

    private ByteContentRange(ByteRange range, long entityLength) {
        this.range = range;
        this.entityLength = entityLength;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteContentRange) {
            ByteContentRange rhs = (ByteContentRange)obj;
            return this.eq(this.range, rhs.range) && this.entityLength == rhs.entityLength;
        }
        return false;
    }

    public int hashCode() {
        int hash = 13;
        hash = 31 * hash + this.hash(this.range);
        hash = 31 * hash + (int)(this.entityLength ^ this.entityLength >>> 32);
        return hash;
    }

    public String toString() {
        if (!this.isSatisfied()) {
            return "bytes */" + this.getEntityLength();
        }
        if (this.isKnownEntityLength()) {
            return "bytes " + this.getLeft() + "-" + this.getRight() + "/" + this.getEntityLength();
        }
        return "bytes " + this.getLeft() + "-" + this.getRight() + "/*";
    }

    public long getLeft() {
        if (!this.isSatisfied()) {
            throw new UnsupportedOperationException();
        }
        return this.range.getLeft();
    }

    public long getRight() {
        if (!this.isSatisfied()) {
            throw new UnsupportedOperationException();
        }
        return this.range.getRight();
    }

    public long getEntityLength() {
        if (!this.isKnownEntityLength()) {
            throw new UnsupportedOperationException();
        }
        return this.entityLength;
    }

    public boolean isSatisfied() {
        return this.range != null;
    }

    public boolean isKnownEntityLength() {
        return this.entityLength >= 0L;
    }

    private boolean eq(Object x, Object y) {
        if (x != null && y != null) {
            return x.equals(y);
        }
        return x == null && y == null;
    }

    private int hash(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }
}

