/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.http.range;

import com.ibm.uclab.csrepl.http.range.ByteContentRange;
import com.ibm.uclab.csrepl.http.range.ByteRange;
import com.ibm.uclab.csrepl.http.range.ContentRangeFormatException;
import com.urbancode.commons.util.Check;

public class ByteContentRangeParser {
    private final String contentRangeHeader;
    private ByteContentRange contentRange;

    public ByteContentRangeParser(String rangeHeader) {
        Check.nonNull((Object)rangeHeader);
        this.contentRangeHeader = rangeHeader;
    }

    public synchronized ByteContentRange getContentRange() throws ContentRangeFormatException {
        if (this.contentRange == null) {
            this.parse();
        }
        return this.contentRange;
    }

    public String toString() {
        return "ByteContentRangeParser {" + this.contentRangeHeader + "}";
    }

    private void parse() throws ContentRangeFormatException {
        int sp = this.contentRangeHeader.indexOf(32);
        if (sp == -1) {
            throw this.newError();
        }
        int slash = this.contentRangeHeader.indexOf(47, sp + 1);
        if (slash == -1) {
            throw this.newError();
        }
        String unit = this.contentRangeHeader.substring(0, sp);
        if (!"bytes".equals(unit)) {
            throw this.newError();
        }
        ByteRange range = this.parseRange(this.contentRangeHeader.substring(sp + 1, slash));
        Long entityLength = this.parseEntityLength(this.contentRangeHeader.substring(slash + 1));
        if (range != null && entityLength != null && range.getRight() > entityLength - 1L) {
            throw this.newError();
        }
        if (range == null && entityLength != null && entityLength <= 0L) {
            throw this.newError();
        }
        if (range == null && entityLength == null) {
            throw this.newError();
        }
        this.contentRange = entityLength == null ? ByteContentRange.forUnknownLengthEntity(range) : (range == null ? ByteContentRange.forUnsatisfiedRange(entityLength) : ByteContentRange.forKnownLengthEntity(range, entityLength));
    }

    private ByteRange parseRange(String s) throws ContentRangeFormatException {
        if (s.length() == 0) {
            throw this.newError();
        }
        if (s.equals("*")) {
            return null;
        }
        int sep = s.indexOf(45);
        if (sep == -1) {
            throw this.newError();
        }
        long left = this.parseLong(s.substring(0, sep));
        long right = this.parseLong(s.substring(sep + 1));
        if (right < left || left == Long.MAX_VALUE || right == Long.MAX_VALUE) {
            throw this.newError();
        }
        return ByteRange.fromTo(left, right);
    }

    private long parseLong(String s) throws ContentRangeFormatException {
        try {
            long v = Long.parseLong(s);
            if (v < 0L) {
                throw this.newError();
            }
            return v;
        }
        catch (NumberFormatException e) {
            throw this.newError();
        }
    }

    private Long parseEntityLength(String s) throws ContentRangeFormatException {
        if (s.length() == 0) {
            throw this.newError();
        }
        if (s.equals("*")) {
            return null;
        }
        return this.parseLong(s);
    }

    private ContentRangeFormatException newError() {
        return new ContentRangeFormatException("bad byte content range: " + this.contentRangeHeader);
    }
}

