/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.http.range;

import com.urbancode.commons.util.Check;

public class ByteRange {
    public static final String UNIT = "bytes";
    private final long left;
    private final long right;

    public static ByteRange fromTo(long left, long right) {
        Check.nonNegative((long)left);
        Check.nonNegative((long)right);
        return new ByteRange(left, right);
    }

    public static ByteRange fromToEnd(long left) {
        Check.nonNegative((long)left);
        return new ByteRange(left, -1L);
    }

    public static ByteRange last(long right) {
        Check.nonNegative((long)right);
        return new ByteRange(-1L, right);
    }

    private ByteRange(long left, long right) {
        if (left < -1L || right < -1L || left == -1L && right == -1L || left != -1L && right != -1L && right < left || left == Long.MAX_VALUE || left != -1L && right == Long.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("invalid range: left=%d right=%d", left, right));
        }
        this.left = left;
        this.right = right;
    }

    public long getLeft() {
        if (this.isLastRange()) {
            throw new UnsupportedOperationException("'last' range has no left: range=" + this);
        }
        return this.left;
    }

    public long getRight() {
        if (this.isFromToEndRange()) {
            throw new UnsupportedOperationException("'fromToEnd' range has no right: range=" + this);
        }
        return this.right;
    }

    public boolean isSatisfiable(long entityLength) {
        if (entityLength == 0L) {
            return false;
        }
        if (this.left == -1L && this.right == 0L) {
            return false;
        }
        return this.left < entityLength;
    }

    public ByteRange asSatisfiedRange(long entityLength) {
        Check.nonNegative((long)entityLength);
        if (!this.isSatisfiable(entityLength)) {
            throw new IllegalArgumentException(String.format("range does not overlap entity: range=%s entity-length=%d", this, entityLength));
        }
        long offset = this.getAbsoluteOffset(entityLength);
        long length = this.getAbsoluteLength(entityLength);
        long left = offset;
        long right = Math.min(entityLength, offset + length) - 1L;
        if (left == this.left && right == this.right) {
            return this;
        }
        return ByteRange.fromTo(left, right);
    }

    public long getAbsoluteOffset(long entityLength) {
        Check.nonNegative((long)entityLength);
        if (this.isLastRange()) {
            return Math.max(0L, entityLength - this.getRight());
        }
        long left = this.getLeft();
        if (left >= entityLength) {
            return 0L;
        }
        return left;
    }

    public long getAbsoluteLength(long entityLength) {
        Check.nonNegative((long)entityLength);
        if (this.isLastRange()) {
            return Math.min(this.getRight(), entityLength);
        }
        long left = this.getLeft();
        if (left >= entityLength) {
            return 0L;
        }
        if (this.isFromToEndRange()) {
            return entityLength - left;
        }
        long right = this.getRight();
        if (right >= entityLength) {
            return entityLength - left;
        }
        return right - left + 1L;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteRange) {
            ByteRange rhs = (ByteRange)obj;
            return this.left == rhs.left && this.right == rhs.right;
        }
        return false;
    }

    public int hashCode() {
        int h = 13;
        h = 31 * h + (int)(this.left ^ this.left >>> 32);
        h = 31 * h + (int)(this.right ^ this.right >>> 32);
        return h;
    }

    public String toString() {
        if (this.isLastRange()) {
            return "bytes=-" + this.getRight();
        }
        if (this.isFromToEndRange()) {
            return "bytes=" + this.getLeft() + "-";
        }
        return "bytes=" + this.getLeft() + "-" + this.getRight();
    }

    boolean isContentRangeCompatible() {
        return !this.isLastRange() && !this.isFromToEndRange();
    }

    public boolean isLastRange() {
        return this.left == -1L;
    }

    public boolean isFromToEndRange() {
        return this.right == -1L;
    }
}

