/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.ptrstore;

import com.ibm.uclab.csrepl.ptrstore.GeoTagListParser;
import com.ibm.uclab.csrepl.ptrstore.IDMappingParser;
import com.ibm.uclab.csrepl.ptrstore.ParseException;
import com.urbancode.commons.util.Check;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class IDMapping {
    private final UUID artifactSetId;
    private final UUID blobId;
    private final Set<String> geoTags;
    private final Map<String, String> extraProperties;

    public IDMapping(UUID artifactSetId, UUID blobId) {
        Check.nonNull((Object)artifactSetId, (String)"artifactSetId");
        Check.nonNull((Object)blobId, (String)"blobId");
        this.artifactSetId = artifactSetId;
        this.blobId = blobId;
        this.geoTags = null;
        this.extraProperties = null;
    }

    public IDMapping(String mapping) {
        IDMappingParser parser = new IDMappingParser(mapping);
        Set<String> tags = parser.getGeoTags();
        Map<String, String> props = parser.getExtraProperties();
        if (tags.isEmpty()) {
            tags = null;
        }
        if (props.isEmpty()) {
            props = null;
        }
        this.artifactSetId = parser.getArtifactSetId();
        this.blobId = parser.getBlobId();
        this.geoTags = tags;
        this.extraProperties = props;
    }

    private IDMapping(UUID artifactSetId, UUID blobId, Set<String> geoTags, Map<String, String> extraProperties) {
        this.artifactSetId = artifactSetId;
        this.blobId = blobId;
        this.geoTags = geoTags;
        this.extraProperties = extraProperties;
    }

    public UUID getArtifactSetId() {
        return this.artifactSetId;
    }

    public IDMapping withArtifactSetId(UUID artifactSetId) {
        Check.nonNull((Object)artifactSetId, (String)"artifactSetId");
        return new IDMapping(artifactSetId, this.blobId, this.geoTags, this.extraProperties);
    }

    public UUID getBlobId() {
        return this.blobId;
    }

    public IDMapping withBlobId(UUID blobId) {
        Check.nonNull((Object)blobId, (String)"blobId");
        return new IDMapping(this.artifactSetId, blobId, this.geoTags, this.extraProperties);
    }

    public Set<String> getGeoTags() {
        if (this.geoTags == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.geoTags);
    }

    public IDMapping withGeoTags(Collection<String> geoTags) {
        LinkedHashSet<String> tags = new LinkedHashSet<String>(geoTags);
        for (String t : tags) {
            this.validateTag(t);
        }
        return new IDMapping(this.artifactSetId, this.blobId, tags, this.extraProperties);
    }

    public IDMapping withGeoTag(String tag) {
        this.validateTag(tag);
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        if (this.geoTags != null) {
            tags.addAll(this.geoTags);
        }
        tags.add(tag);
        return new IDMapping(this.artifactSetId, this.blobId, tags, this.extraProperties);
    }

    public IDMapping withoutGeoTag(String tag) {
        if (this.geoTags == null || !this.geoTags.contains(tag)) {
            return this;
        }
        if (this.geoTags.size() == 1) {
            return new IDMapping(this.artifactSetId, this.blobId, null, this.extraProperties);
        }
        LinkedHashSet<String> tags = new LinkedHashSet<String>(this.geoTags);
        tags.remove(tag);
        return new IDMapping(this.artifactSetId, this.blobId, tags, this.extraProperties);
    }

    public Map<String, String> getExtraProperties() {
        if (this.extraProperties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.extraProperties);
    }

    public IDMapping withExtraProperty(String name, String value) {
        this.validatePropName(name);
        this.validatePropValue(value);
        if ("geo".equals(name)) {
            try {
                Set<String> tags = new GeoTagListParser(value).getGeoTags();
                return new IDMapping(this.artifactSetId, this.blobId, tags, this.extraProperties);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid geo tag list: " + value, e);
            }
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        if (this.extraProperties != null) {
            props.putAll(this.extraProperties);
        }
        props.put(name, value);
        return new IDMapping(this.artifactSetId, this.blobId, this.geoTags, props);
    }

    public IDMapping withoutExtraProperty(String name) {
        if (this.extraProperties == null || !this.extraProperties.containsKey(name)) {
            return this;
        }
        if (this.extraProperties.size() == 1) {
            return new IDMapping(this.artifactSetId, this.blobId, this.geoTags, null);
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(this.extraProperties);
        props.remove(name);
        return new IDMapping(this.artifactSetId, this.blobId, this.geoTags, props);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IDMapping) {
            IDMapping rhs = (IDMapping)obj;
            return this.artifactSetId.equals(rhs.artifactSetId) && this.blobId.equals(rhs.blobId) && this.eq(this.geoTags, rhs.geoTags) && this.eq(this.extraProperties, rhs.extraProperties);
        }
        return false;
    }

    public int hashCode() {
        int h = 31;
        h = 13 * h + this.artifactSetId.hashCode();
        h = 13 * h + this.blobId.hashCode();
        h = 13 * h + this.hash(this.geoTags);
        h = 13 * h + this.hash(this.extraProperties);
        return h;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getArtifactSetId());
        sb.append("=");
        sb.append(this.getBlobId());
        this.appendGeoTags(sb);
        this.appendExtraProperties(sb);
        return sb.toString();
    }

    private void appendGeoTags(StringBuilder sb) {
        Iterator<String> i = this.getGeoTags().iterator();
        if (i.hasNext()) {
            sb.append(";geo:");
            sb.append(IDMappingParser.escapePropVal(GeoTagListParser.escapeTag(i.next())));
        }
        while (i.hasNext()) {
            sb.append(",");
            sb.append(IDMappingParser.escapePropVal(GeoTagListParser.escapeTag(i.next())));
        }
    }

    private void appendExtraProperties(StringBuilder sb) {
        for (Map.Entry<String, String> e : this.getExtraProperties().entrySet()) {
            sb.append(";");
            sb.append(e.getKey());
            sb.append(":");
            sb.append(IDMappingParser.escapePropVal(e.getValue()));
        }
    }

    private void validateTag(String tag) {
        Check.nonNull((Object)tag);
        if (tag.length() == 0) {
            throw new IllegalArgumentException("Invalid tag: " + tag);
        }
    }

    private void validatePropName(String name) {
        Check.nonNull((Object)name);
        if (name.length() == 0) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        if (!IDMappingParser.isNameStartChar(name.charAt(0))) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        for (int i = 1; i < name.length(); ++i) {
            if (IDMappingParser.isNameChar(name.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid name: " + name);
        }
    }

    private void validatePropValue(String value) {
        Check.nonNull((Object)value);
        if (value.length() == 0) {
            return;
        }
        if (value.startsWith(" ") || value.endsWith(" ")) {
            throw new IllegalArgumentException("Invalid value: " + value);
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (IDMappingParser.isValueChar(c)) continue;
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    private int hash(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    private boolean eq(Map<String, String> a, Map<String, String> b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return b.isEmpty();
        }
        if (b == null) {
            return a.isEmpty();
        }
        return a.equals(b);
    }

    private boolean eq(Set<String> a, Set<String> b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return b.isEmpty();
        }
        if (b == null) {
            return a.isEmpty();
        }
        return a.equals(b);
    }
}

